/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.gateway.gatewaysetting;

import com.tplink.smb.omada.manager.configuration.api.openapi.gateway.gatewaysetting.OsgLtePinSettingOpenApiVO;
import com.tplink.smb.omada.manager.device.api.web.osg.dto.OsgLtePinVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class OsgLtePinOpenApiVO {
    @Schema(name="type", description="Type of change: 1: Changing the PIN setting, 2: Changing the PIN code.")
    private Integer type;
    @Schema(name="firstTry", description="Whether the first attempt was successful.")
    private Boolean firstTry;
    @Schema(name="pinCode", description="PIN code.")
    private String pinCode;
    @Schema(name="pukCode", description="PUK code.")
    private String pukCode;
    @Schema(name="newPinCode", description="New PIN code")
    private String newPinCode;
    @Schema(name="pinSetting", description="PIN settings.")
    private OsgLtePinSettingOpenApiVO pinSetting;
    @Schema(name="simCard", description="When the device supports Dual-SIM card, parameter [simCard] should not be null.1: SIM1; 2: SIM2.")
    @Range(min=1L, max=2L, message="Value of simCard is 1 or 2.")
    private @Range(min=1L, max=2L, message="Value of simCard is 1 or 2.") Integer simCard;

    public static OsgLtePinVO toWebVO(OsgLtePinOpenApiVO vo) {
        OsgLtePinVO res = new OsgLtePinVO();
        if (Objects.isNull(vo)) {
            return res;
        }
        res.setType(vo.getType());
        res.setFirstTry(vo.getFirstTry());
        res.setPinCode(vo.getPinCode());
        res.setPukCode(vo.getPukCode());
        res.setNewPinCode(vo.getNewPinCode());
        res.setPinSetting(OsgLtePinSettingOpenApiVO.toWebVO(vo.getPinSetting()));
        res.setSimCard(vo.getSimCard());
        return res;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public Boolean getFirstTry() {
        return this.firstTry;
    }

    @Generated
    public String getPinCode() {
        return this.pinCode;
    }

    @Generated
    public String getPukCode() {
        return this.pukCode;
    }

    @Generated
    public String getNewPinCode() {
        return this.newPinCode;
    }

    @Generated
    public OsgLtePinSettingOpenApiVO getPinSetting() {
        return this.pinSetting;
    }

    @Generated
    public Integer getSimCard() {
        return this.simCard;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setFirstTry(Boolean firstTry) {
        this.firstTry = firstTry;
    }

    @Generated
    public void setPinCode(String pinCode) {
        this.pinCode = pinCode;
    }

    @Generated
    public void setPukCode(String pukCode) {
        this.pukCode = pukCode;
    }

    @Generated
    public void setNewPinCode(String newPinCode) {
        this.newPinCode = newPinCode;
    }

    @Generated
    public void setPinSetting(OsgLtePinSettingOpenApiVO pinSetting) {
        this.pinSetting = pinSetting;
    }

    @Generated
    public void setSimCard(Integer simCard) {
        this.simCard = simCard;
    }

    @Generated
    public String toString() {
        return "OsgLtePinOpenApiVO(type=" + this.getType() + ", firstTry=" + this.getFirstTry() + ", pinCode=" + this.getPinCode() + ", pukCode=" + this.getPukCode() + ", newPinCode=" + this.getNewPinCode() + ", pinSetting=" + this.getPinSetting() + ", simCard=" + this.getSimCard() + ")";
    }
}

