/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.gateway.gatewaysetting;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.openapi.gateway.gatewaysetting.OsgSnmpOpenApiVO;
import com.tplink.smb.omada.manager.device.api.web.device.dto.DeviceLocationDetailVO;
import com.tplink.smb.omada.manager.device.api.web.osg.dto.OsgConfigGeneralVO;
import com.tplink.smb.omada.manager.device.api.web.osg.dto.OsgConfigVO;
import com.tplink.smb.omada.manager.device.api.web.osg.dto.OsgDetailVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;

@Schema(name="GatewayGeneralConfig")
public class OsgGeneralConfigOpenApiVO {
    @Schema(name="name", description="Device name should contain 1 to 128 characters.")
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters")
    private @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters") String name;
    @Schema(name="ledSetting", description="Led setting should be a value as follows: 0:off; 1:on; 2:Use Site Settings")
    @NumberSet(value={0, 1, 2}, message="Parameter [ledSetting] should be 0 or 1 or 2")
    @NotNull(message="Parameter [ledSetting] should be 0 or 1 or 2")
    private @NotNull(message="Parameter [ledSetting] should be 0 or 1 or 2") Integer ledSetting;
    @Schema(name="tagIds", description="Tag IDs")
    private List<String> tagIds;
    @Schema(name="location", description="Device location")
    @Valid
    private DeviceLocationDetailVO location;
    @Schema(name="snmp", description="Snmp setting")
    @Valid
    private OsgSnmpOpenApiVO snmp;
    @NumberSet(value={0, 1, 2}, message="Parameter [rememberDevice] should be 0 or 1 or 2")
    private Integer rememberDevice;

    public static OsgGeneralConfigOpenApiVO buildFromOsgDetailVO(OsgDetailVO vo) {
        OsgGeneralConfigOpenApiVO res = new OsgGeneralConfigOpenApiVO();
        if (vo == null) {
            return res;
        }
        res.setName(vo.getName());
        res.setLedSetting(vo.getLedSetting());
        res.setLocation(vo.getLocation());
        res.setTagIds(vo.getTagIds());
        res.setSnmp(OsgSnmpOpenApiVO.fromWebVO(vo.getSnmpSeting()));
        res.setRememberDevice(vo.getRememberDevice());
        return res;
    }

    public static OsgConfigVO toWebVO(OsgGeneralConfigOpenApiVO vo) {
        OsgConfigVO res = new OsgConfigVO();
        if (vo == null) {
            return res;
        }
        res.setName(vo.getName());
        res.setTagIds(vo.getTagIds());
        res.setLocation(vo.getLocation());
        res.setLedSetting(vo.getLedSetting());
        res.setSnmp(OsgSnmpOpenApiVO.toWebVO(vo.getSnmp()));
        res.setRememberDevice(vo.getRememberDevice());
        return res;
    }

    public static OsgConfigGeneralVO toConfigGeneralVO(OsgGeneralConfigOpenApiVO vo) {
        if (vo == null) {
            return null;
        }
        OsgConfigGeneralVO res = new OsgConfigGeneralVO();
        res.setName(vo.getName());
        res.setTagIds(vo.getTagIds());
        res.setLocation(vo.getLocation());
        res.setLedSetting(vo.getLedSetting());
        res.setSnmp(OsgSnmpOpenApiVO.toWebVO(vo.getSnmp()));
        res.setRememberDevice(vo.getRememberDevice());
        return res;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getLedSetting() {
        return this.ledSetting;
    }

    @Generated
    public List<String> getTagIds() {
        return this.tagIds;
    }

    @Generated
    public DeviceLocationDetailVO getLocation() {
        return this.location;
    }

    @Generated
    public OsgSnmpOpenApiVO getSnmp() {
        return this.snmp;
    }

    @Generated
    public Integer getRememberDevice() {
        return this.rememberDevice;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setLedSetting(Integer ledSetting) {
        this.ledSetting = ledSetting;
    }

    @Generated
    public void setTagIds(List<String> tagIds) {
        this.tagIds = tagIds;
    }

    @Generated
    public void setLocation(DeviceLocationDetailVO location) {
        this.location = location;
    }

    @Generated
    public void setSnmp(OsgSnmpOpenApiVO snmp) {
        this.snmp = snmp;
    }

    @Generated
    public void setRememberDevice(Integer rememberDevice) {
        this.rememberDevice = rememberDevice;
    }

    @Generated
    public String toString() {
        return "OsgGeneralConfigOpenApiVO(name=" + this.getName() + ", ledSetting=" + this.getLedSetting() + ", tagIds=" + this.getTagIds() + ", location=" + this.getLocation() + ", snmp=" + this.getSnmp() + ", rememberDevice=" + this.getRememberDevice() + ")";
    }
}

