/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.gateway.gatewaysetting;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.openapi.gateway.gatewaysetting.DeviceLocationDetailOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.gateway.gatewaysetting.OsgSnmpOpenApiVO;
import com.tplink.smb.omada.manager.device.api.web.osg.dto.OsgConfigGeneralVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;

public class OsgGeneralConfigOpenApiV2VO {
    @Schema(name="name", description="Device name should contain 1 to 128 characters. This subsection is deprecated.")
    @Deprecated
    private String name;
    @Schema(name="ledSetting", description="Led setting should be a value as follows: 0:off; 1:on; 2:Use Site Settings")
    @NumberSet(value={0, 1, 2}, message="Parameter [ledSetting] should be 0 or 1 or 2")
    @NotNull(message="Parameter [ledSetting] should be 0 or 1 or 2")
    private @NotNull(message="Parameter [ledSetting] should be 0 or 1 or 2") Integer ledSetting;
    @Schema(name="tagIds", description="Tag IDs. This subsection is deprecated.")
    @Deprecated
    private List<String> tagIds;
    @Deprecated
    @Schema(name="location", description="Device location. This subsection is deprecated.")
    private DeviceLocationDetailOpenApiVO location;
    @Schema(name="snmp", description="Snmp setting")
    @Valid
    private OsgSnmpOpenApiVO snmp;
    @NumberSet(value={0, 1, 2}, message="Parameter [rememberDevice] should be 0 or 1 or 2")
    private Integer rememberDevice;

    public static OsgConfigGeneralVO toConfigGeneralVO(OsgGeneralConfigOpenApiV2VO vo) {
        OsgConfigGeneralVO res = new OsgConfigGeneralVO();
        if (vo == null) {
            return res;
        }
        res.setLedSetting(vo.getLedSetting());
        res.setSnmp(OsgSnmpOpenApiVO.toWebVO(vo.getSnmp()));
        res.setRememberDevice(vo.getRememberDevice());
        return res;
    }

    @Deprecated
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getLedSetting() {
        return this.ledSetting;
    }

    @Deprecated
    @Generated
    public List<String> getTagIds() {
        return this.tagIds;
    }

    @Deprecated
    @Generated
    public DeviceLocationDetailOpenApiVO getLocation() {
        return this.location;
    }

    @Generated
    public OsgSnmpOpenApiVO getSnmp() {
        return this.snmp;
    }

    @Generated
    public Integer getRememberDevice() {
        return this.rememberDevice;
    }

    @Deprecated
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setLedSetting(Integer ledSetting) {
        this.ledSetting = ledSetting;
    }

    @Deprecated
    @Generated
    public void setTagIds(List<String> tagIds) {
        this.tagIds = tagIds;
    }

    @Deprecated
    @Generated
    public void setLocation(DeviceLocationDetailOpenApiVO location) {
        this.location = location;
    }

    @Generated
    public void setSnmp(OsgSnmpOpenApiVO snmp) {
        this.snmp = snmp;
    }

    @Generated
    public void setRememberDevice(Integer rememberDevice) {
        this.rememberDevice = rememberDevice;
    }

    @Generated
    public String toString() {
        return "OsgGeneralConfigOpenApiV2VO(name=" + this.getName() + ", ledSetting=" + this.getLedSetting() + ", tagIds=" + this.getTagIds() + ", location=" + this.getLocation() + ", snmp=" + this.getSnmp() + ", rememberDevice=" + this.getRememberDevice() + ")";
    }

    @Generated
    public OsgGeneralConfigOpenApiV2VO() {
    }
}

