/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.gateway.gatewaysetting;

import com.tplink.smb.omada.manager.configuration.api.openapi.gateway.gatewaysetting.OsgPortPoeOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.ap.apsetting.ApLoadBalanceOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.ap.apsetting.ApQosOpenApiVO;
import com.tplink.smb.omada.manager.device.api.openapi.ap.apsetting.ApRssiThresholdOpenApiVO;
import com.tplink.smb.omada.manager.device.api.web.osg.dto.OsgConfigAdvancedVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class OsgConfigAdvancedOpenApiVO {
    @Schema(name="hwOffloadEnable", description="Hardware Offload enabled or not.")
    private Boolean hwOffloadEnable;
    @Schema(name="lldpEnable", description="LLDP enabled or not. Deprecated, filed lldpSetting is recommended", deprecated=true)
    @Deprecated
    private Boolean lldpEnable;
    @Schema(name="lldpSetting", description="LLDP setting. 0: Off, 1: On, 2: Follow site.")
    private Integer lldpSetting;
    @Schema(name="poeSettings", description="Port Poe setting list.")
    private List<OsgPortPoeOpenApiVO> poeSettings;
    @Schema(name="echoServer", description="Echo Server should be a domain name or IP address.")
    @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Parameter [echoServer] Invalid.")
    private @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Parameter [echoServer] Invalid.") String echoServer;
    @Schema(name="lbSetting2g", description="Load Balance setting of 2.4 GHz.")
    @Valid
    private ApLoadBalanceOpenApiVO lbSetting2g;
    @Schema(name="lbSetting5g", description="Load Balance setting of 5 GHz.")
    @Valid
    private ApLoadBalanceOpenApiVO lbSetting5g;
    @Schema(name="lbSetting5g1", description="Load Balance setting of 5 GHz-1.")
    @Valid
    private ApLoadBalanceOpenApiVO lbSetting5g1;
    @Schema(name="lbSetting5g2", description="Load Balance setting of 5 GHz-2.")
    @Valid
    private ApLoadBalanceOpenApiVO lbSetting5g2;
    @Schema(name="lbSetting6g", description="Load Balance setting of 6 GHz.")
    @Valid
    private ApLoadBalanceOpenApiVO lbSetting6g;
    @Schema(name="rssiSetting2g", description="Rssi Threshold setting of 2.4 GHz.")
    @Valid
    private ApRssiThresholdOpenApiVO rssiSetting2g;
    @Schema(name="rssiSetting5g", description="Rssi Threshold setting of 5 GHz.")
    @Valid
    private ApRssiThresholdOpenApiVO rssiSetting5g;
    @Schema(name="rssiSetting5g1", description="Rssi Threshold setting of 5 GHz-1.")
    @Valid
    private ApRssiThresholdOpenApiVO rssiSetting5g1;
    @Schema(name="rssiSetting5g2", description="Rssi Threshold setting of 5 GHz-2.")
    @Valid
    private ApRssiThresholdOpenApiVO rssiSetting5g2;
    @Schema(name="rssiSetting6g", description="Rssi Threshold setting of 6 GHz.")
    @Valid
    private ApRssiThresholdOpenApiVO rssiSetting6g;
    @Schema(name="qosSetting2g", description="Qos setting of 2.4 GHz.")
    @Valid
    private ApQosOpenApiVO qosSetting2g;
    @Schema(name="qosSetting5g", description="Qos setting of 5 GHz.")
    @Valid
    private ApQosOpenApiVO qosSetting5g;
    @Schema(name="qosSetting5g1", description="Qos setting of 5 GHz-1.")
    @Valid
    private ApQosOpenApiVO qosSetting5g1;
    @Schema(name="qosSetting5g2", description="Qos setting of 5 GHz-2.")
    @Valid
    private ApQosOpenApiVO qosSetting5g2;
    @Schema(name="qosSetting6g", description="Qos setting of 6 GHz.")
    @Valid
    private ApQosOpenApiVO qosSetting6g;
    @Schema(name="ofdmaEnable2g", description="Enable or disable OFDMA of 2.4 GHz.")
    private Boolean ofdmaEnable2g;
    @Schema(name="ofdmaEnable5g", description="Enable or disable OFDMA of 5 GHz.")
    private Boolean ofdmaEnable5g;
    @Schema(name="ofdmaEnable5g1", description="Enable or disable OFDMA of 5 GHz-1.")
    private Boolean ofdmaEnable5g1;
    @Schema(name="ofdmaEnable5g2", description="Enable or disable OFDMA of 5 GHz-2.")
    private Boolean ofdmaEnable5g2;
    @Schema(name="ofdmaEnable6g", description="Enable or disable OFDMA of 6 GHz.")
    private Boolean ofdmaEnable6g;

    public static OsgConfigAdvancedVO toWebVO(OsgConfigAdvancedOpenApiVO vo) {
        if (vo == null) {
            return null;
        }
        OsgConfigAdvancedVO res = new OsgConfigAdvancedVO();
        res.setHwOffloadEnable(vo.getHwOffloadEnable());
        res.setLldpSetting(vo.getLldpSetting());
        res.setLldpEnable(vo.getLldpEnable());
        res.setEchoServer(vo.getEchoServer());
        res.setPoeSettings((List)Optional.ofNullable(vo.getPoeSettings()).map(list -> list.stream().map(OsgPortPoeOpenApiVO::toWebVO).collect(Collectors.toList())).orElse(null));
        res.setLbSetting2g(ApLoadBalanceOpenApiVO.toWebVO(vo.getLbSetting2g()));
        res.setLbSetting5g(ApLoadBalanceOpenApiVO.toWebVO(vo.getLbSetting5g()));
        res.setLbSetting5g1(ApLoadBalanceOpenApiVO.toWebVO(vo.getLbSetting5g1()));
        res.setLbSetting5g2(ApLoadBalanceOpenApiVO.toWebVO(vo.getLbSetting5g2()));
        res.setLbSetting6g(ApLoadBalanceOpenApiVO.toWebVO(vo.getLbSetting6g()));
        res.setRssiSetting2g(ApRssiThresholdOpenApiVO.toWebVO(vo.getRssiSetting2g()));
        res.setRssiSetting5g(ApRssiThresholdOpenApiVO.toWebVO(vo.getRssiSetting5g()));
        res.setRssiSetting5g1(ApRssiThresholdOpenApiVO.toWebVO(vo.getRssiSetting5g1()));
        res.setRssiSetting5g2(ApRssiThresholdOpenApiVO.toWebVO(vo.getRssiSetting5g2()));
        res.setRssiSetting6g(ApRssiThresholdOpenApiVO.toWebVO(vo.getRssiSetting6g()));
        res.setQosSetting2g(ApQosOpenApiVO.toWebVO(vo.getQosSetting2g()));
        res.setQosSetting5g(ApQosOpenApiVO.toWebVO(vo.getQosSetting2g()));
        res.setQosSetting5g1(ApQosOpenApiVO.toWebVO(vo.getQosSetting2g()));
        res.setQosSetting5g2(ApQosOpenApiVO.toWebVO(vo.getQosSetting2g()));
        res.setQosSetting6g(ApQosOpenApiVO.toWebVO(vo.getQosSetting2g()));
        res.setOfdmaEnable2g(vo.getOfdmaEnable2g());
        res.setOfdmaEnable5g(vo.getOfdmaEnable5g());
        res.setOfdmaEnable5g1(vo.getOfdmaEnable5g1());
        res.setOfdmaEnable5g2(vo.getOfdmaEnable5g2());
        res.setOfdmaEnable6g(vo.getOfdmaEnable6g());
        return res;
    }

    @Generated
    protected OsgConfigAdvancedOpenApiVO(OsgConfigAdvancedOpenApiVOBuilder<?, ?> b2) {
        this.hwOffloadEnable = b2.hwOffloadEnable;
        this.lldpEnable = b2.lldpEnable;
        this.lldpSetting = b2.lldpSetting;
        this.poeSettings = b2.poeSettings;
        this.echoServer = b2.echoServer;
        this.lbSetting2g = b2.lbSetting2g;
        this.lbSetting5g = b2.lbSetting5g;
        this.lbSetting5g1 = b2.lbSetting5g1;
        this.lbSetting5g2 = b2.lbSetting5g2;
        this.lbSetting6g = b2.lbSetting6g;
        this.rssiSetting2g = b2.rssiSetting2g;
        this.rssiSetting5g = b2.rssiSetting5g;
        this.rssiSetting5g1 = b2.rssiSetting5g1;
        this.rssiSetting5g2 = b2.rssiSetting5g2;
        this.rssiSetting6g = b2.rssiSetting6g;
        this.qosSetting2g = b2.qosSetting2g;
        this.qosSetting5g = b2.qosSetting5g;
        this.qosSetting5g1 = b2.qosSetting5g1;
        this.qosSetting5g2 = b2.qosSetting5g2;
        this.qosSetting6g = b2.qosSetting6g;
        this.ofdmaEnable2g = b2.ofdmaEnable2g;
        this.ofdmaEnable5g = b2.ofdmaEnable5g;
        this.ofdmaEnable5g1 = b2.ofdmaEnable5g1;
        this.ofdmaEnable5g2 = b2.ofdmaEnable5g2;
        this.ofdmaEnable6g = b2.ofdmaEnable6g;
    }

    @Generated
    public static OsgConfigAdvancedOpenApiVOBuilder<?, ?> builder() {
        return new OsgConfigAdvancedOpenApiVOBuilderImpl();
    }

    @Generated
    public Boolean getHwOffloadEnable() {
        return this.hwOffloadEnable;
    }

    @Deprecated
    @Generated
    public Boolean getLldpEnable() {
        return this.lldpEnable;
    }

    @Generated
    public Integer getLldpSetting() {
        return this.lldpSetting;
    }

    @Generated
    public List<OsgPortPoeOpenApiVO> getPoeSettings() {
        return this.poeSettings;
    }

    @Generated
    public String getEchoServer() {
        return this.echoServer;
    }

    @Generated
    public ApLoadBalanceOpenApiVO getLbSetting2g() {
        return this.lbSetting2g;
    }

    @Generated
    public ApLoadBalanceOpenApiVO getLbSetting5g() {
        return this.lbSetting5g;
    }

    @Generated
    public ApLoadBalanceOpenApiVO getLbSetting5g1() {
        return this.lbSetting5g1;
    }

    @Generated
    public ApLoadBalanceOpenApiVO getLbSetting5g2() {
        return this.lbSetting5g2;
    }

    @Generated
    public ApLoadBalanceOpenApiVO getLbSetting6g() {
        return this.lbSetting6g;
    }

    @Generated
    public ApRssiThresholdOpenApiVO getRssiSetting2g() {
        return this.rssiSetting2g;
    }

    @Generated
    public ApRssiThresholdOpenApiVO getRssiSetting5g() {
        return this.rssiSetting5g;
    }

    @Generated
    public ApRssiThresholdOpenApiVO getRssiSetting5g1() {
        return this.rssiSetting5g1;
    }

    @Generated
    public ApRssiThresholdOpenApiVO getRssiSetting5g2() {
        return this.rssiSetting5g2;
    }

    @Generated
    public ApRssiThresholdOpenApiVO getRssiSetting6g() {
        return this.rssiSetting6g;
    }

    @Generated
    public ApQosOpenApiVO getQosSetting2g() {
        return this.qosSetting2g;
    }

    @Generated
    public ApQosOpenApiVO getQosSetting5g() {
        return this.qosSetting5g;
    }

    @Generated
    public ApQosOpenApiVO getQosSetting5g1() {
        return this.qosSetting5g1;
    }

    @Generated
    public ApQosOpenApiVO getQosSetting5g2() {
        return this.qosSetting5g2;
    }

    @Generated
    public ApQosOpenApiVO getQosSetting6g() {
        return this.qosSetting6g;
    }

    @Generated
    public Boolean getOfdmaEnable2g() {
        return this.ofdmaEnable2g;
    }

    @Generated
    public Boolean getOfdmaEnable5g() {
        return this.ofdmaEnable5g;
    }

    @Generated
    public Boolean getOfdmaEnable5g1() {
        return this.ofdmaEnable5g1;
    }

    @Generated
    public Boolean getOfdmaEnable5g2() {
        return this.ofdmaEnable5g2;
    }

    @Generated
    public Boolean getOfdmaEnable6g() {
        return this.ofdmaEnable6g;
    }

    @Generated
    public void setHwOffloadEnable(Boolean hwOffloadEnable) {
        this.hwOffloadEnable = hwOffloadEnable;
    }

    @Deprecated
    @Generated
    public void setLldpEnable(Boolean lldpEnable) {
        this.lldpEnable = lldpEnable;
    }

    @Generated
    public void setLldpSetting(Integer lldpSetting) {
        this.lldpSetting = lldpSetting;
    }

    @Generated
    public void setPoeSettings(List<OsgPortPoeOpenApiVO> poeSettings) {
        this.poeSettings = poeSettings;
    }

    @Generated
    public void setEchoServer(String echoServer) {
        this.echoServer = echoServer;
    }

    @Generated
    public void setLbSetting2g(ApLoadBalanceOpenApiVO lbSetting2g) {
        this.lbSetting2g = lbSetting2g;
    }

    @Generated
    public void setLbSetting5g(ApLoadBalanceOpenApiVO lbSetting5g) {
        this.lbSetting5g = lbSetting5g;
    }

    @Generated
    public void setLbSetting5g1(ApLoadBalanceOpenApiVO lbSetting5g1) {
        this.lbSetting5g1 = lbSetting5g1;
    }

    @Generated
    public void setLbSetting5g2(ApLoadBalanceOpenApiVO lbSetting5g2) {
        this.lbSetting5g2 = lbSetting5g2;
    }

    @Generated
    public void setLbSetting6g(ApLoadBalanceOpenApiVO lbSetting6g) {
        this.lbSetting6g = lbSetting6g;
    }

    @Generated
    public void setRssiSetting2g(ApRssiThresholdOpenApiVO rssiSetting2g) {
        this.rssiSetting2g = rssiSetting2g;
    }

    @Generated
    public void setRssiSetting5g(ApRssiThresholdOpenApiVO rssiSetting5g) {
        this.rssiSetting5g = rssiSetting5g;
    }

    @Generated
    public void setRssiSetting5g1(ApRssiThresholdOpenApiVO rssiSetting5g1) {
        this.rssiSetting5g1 = rssiSetting5g1;
    }

    @Generated
    public void setRssiSetting5g2(ApRssiThresholdOpenApiVO rssiSetting5g2) {
        this.rssiSetting5g2 = rssiSetting5g2;
    }

    @Generated
    public void setRssiSetting6g(ApRssiThresholdOpenApiVO rssiSetting6g) {
        this.rssiSetting6g = rssiSetting6g;
    }

    @Generated
    public void setQosSetting2g(ApQosOpenApiVO qosSetting2g) {
        this.qosSetting2g = qosSetting2g;
    }

    @Generated
    public void setQosSetting5g(ApQosOpenApiVO qosSetting5g) {
        this.qosSetting5g = qosSetting5g;
    }

    @Generated
    public void setQosSetting5g1(ApQosOpenApiVO qosSetting5g1) {
        this.qosSetting5g1 = qosSetting5g1;
    }

    @Generated
    public void setQosSetting5g2(ApQosOpenApiVO qosSetting5g2) {
        this.qosSetting5g2 = qosSetting5g2;
    }

    @Generated
    public void setQosSetting6g(ApQosOpenApiVO qosSetting6g) {
        this.qosSetting6g = qosSetting6g;
    }

    @Generated
    public void setOfdmaEnable2g(Boolean ofdmaEnable2g) {
        this.ofdmaEnable2g = ofdmaEnable2g;
    }

    @Generated
    public void setOfdmaEnable5g(Boolean ofdmaEnable5g) {
        this.ofdmaEnable5g = ofdmaEnable5g;
    }

    @Generated
    public void setOfdmaEnable5g1(Boolean ofdmaEnable5g1) {
        this.ofdmaEnable5g1 = ofdmaEnable5g1;
    }

    @Generated
    public void setOfdmaEnable5g2(Boolean ofdmaEnable5g2) {
        this.ofdmaEnable5g2 = ofdmaEnable5g2;
    }

    @Generated
    public void setOfdmaEnable6g(Boolean ofdmaEnable6g) {
        this.ofdmaEnable6g = ofdmaEnable6g;
    }

    @Generated
    public OsgConfigAdvancedOpenApiVO() {
    }

    @Generated
    public OsgConfigAdvancedOpenApiVO(Boolean hwOffloadEnable, Boolean lldpEnable, Integer lldpSetting, List<OsgPortPoeOpenApiVO> poeSettings, String echoServer, ApLoadBalanceOpenApiVO lbSetting2g, ApLoadBalanceOpenApiVO lbSetting5g, ApLoadBalanceOpenApiVO lbSetting5g1, ApLoadBalanceOpenApiVO lbSetting5g2, ApLoadBalanceOpenApiVO lbSetting6g, ApRssiThresholdOpenApiVO rssiSetting2g, ApRssiThresholdOpenApiVO rssiSetting5g, ApRssiThresholdOpenApiVO rssiSetting5g1, ApRssiThresholdOpenApiVO rssiSetting5g2, ApRssiThresholdOpenApiVO rssiSetting6g, ApQosOpenApiVO qosSetting2g, ApQosOpenApiVO qosSetting5g, ApQosOpenApiVO qosSetting5g1, ApQosOpenApiVO qosSetting5g2, ApQosOpenApiVO qosSetting6g, Boolean ofdmaEnable2g, Boolean ofdmaEnable5g, Boolean ofdmaEnable5g1, Boolean ofdmaEnable5g2, Boolean ofdmaEnable6g) {
        this.hwOffloadEnable = hwOffloadEnable;
        this.lldpEnable = lldpEnable;
        this.lldpSetting = lldpSetting;
        this.poeSettings = poeSettings;
        this.echoServer = echoServer;
        this.lbSetting2g = lbSetting2g;
        this.lbSetting5g = lbSetting5g;
        this.lbSetting5g1 = lbSetting5g1;
        this.lbSetting5g2 = lbSetting5g2;
        this.lbSetting6g = lbSetting6g;
        this.rssiSetting2g = rssiSetting2g;
        this.rssiSetting5g = rssiSetting5g;
        this.rssiSetting5g1 = rssiSetting5g1;
        this.rssiSetting5g2 = rssiSetting5g2;
        this.rssiSetting6g = rssiSetting6g;
        this.qosSetting2g = qosSetting2g;
        this.qosSetting5g = qosSetting5g;
        this.qosSetting5g1 = qosSetting5g1;
        this.qosSetting5g2 = qosSetting5g2;
        this.qosSetting6g = qosSetting6g;
        this.ofdmaEnable2g = ofdmaEnable2g;
        this.ofdmaEnable5g = ofdmaEnable5g;
        this.ofdmaEnable5g1 = ofdmaEnable5g1;
        this.ofdmaEnable5g2 = ofdmaEnable5g2;
        this.ofdmaEnable6g = ofdmaEnable6g;
    }

    @Generated
    public String toString() {
        return "OsgConfigAdvancedOpenApiVO(hwOffloadEnable=" + this.getHwOffloadEnable() + ", lldpEnable=" + this.getLldpEnable() + ", lldpSetting=" + this.getLldpSetting() + ", poeSettings=" + this.getPoeSettings() + ", echoServer=" + this.getEchoServer() + ", lbSetting2g=" + this.getLbSetting2g() + ", lbSetting5g=" + this.getLbSetting5g() + ", lbSetting5g1=" + this.getLbSetting5g1() + ", lbSetting5g2=" + this.getLbSetting5g2() + ", lbSetting6g=" + this.getLbSetting6g() + ", rssiSetting2g=" + this.getRssiSetting2g() + ", rssiSetting5g=" + this.getRssiSetting5g() + ", rssiSetting5g1=" + this.getRssiSetting5g1() + ", rssiSetting5g2=" + this.getRssiSetting5g2() + ", rssiSetting6g=" + this.getRssiSetting6g() + ", qosSetting2g=" + this.getQosSetting2g() + ", qosSetting5g=" + this.getQosSetting5g() + ", qosSetting5g1=" + this.getQosSetting5g1() + ", qosSetting5g2=" + this.getQosSetting5g2() + ", qosSetting6g=" + this.getQosSetting6g() + ", ofdmaEnable2g=" + this.getOfdmaEnable2g() + ", ofdmaEnable5g=" + this.getOfdmaEnable5g() + ", ofdmaEnable5g1=" + this.getOfdmaEnable5g1() + ", ofdmaEnable5g2=" + this.getOfdmaEnable5g2() + ", ofdmaEnable6g=" + this.getOfdmaEnable6g() + ")";
    }

    @Generated
    public static abstract class OsgConfigAdvancedOpenApiVOBuilder<C extends OsgConfigAdvancedOpenApiVO, B extends OsgConfigAdvancedOpenApiVOBuilder<C, B>> {
        @Generated
        private Boolean hwOffloadEnable;
        @Generated
        private Boolean lldpEnable;
        @Generated
        private Integer lldpSetting;
        @Generated
        private List<OsgPortPoeOpenApiVO> poeSettings;
        @Generated
        private String echoServer;
        @Generated
        private ApLoadBalanceOpenApiVO lbSetting2g;
        @Generated
        private ApLoadBalanceOpenApiVO lbSetting5g;
        @Generated
        private ApLoadBalanceOpenApiVO lbSetting5g1;
        @Generated
        private ApLoadBalanceOpenApiVO lbSetting5g2;
        @Generated
        private ApLoadBalanceOpenApiVO lbSetting6g;
        @Generated
        private ApRssiThresholdOpenApiVO rssiSetting2g;
        @Generated
        private ApRssiThresholdOpenApiVO rssiSetting5g;
        @Generated
        private ApRssiThresholdOpenApiVO rssiSetting5g1;
        @Generated
        private ApRssiThresholdOpenApiVO rssiSetting5g2;
        @Generated
        private ApRssiThresholdOpenApiVO rssiSetting6g;
        @Generated
        private ApQosOpenApiVO qosSetting2g;
        @Generated
        private ApQosOpenApiVO qosSetting5g;
        @Generated
        private ApQosOpenApiVO qosSetting5g1;
        @Generated
        private ApQosOpenApiVO qosSetting5g2;
        @Generated
        private ApQosOpenApiVO qosSetting6g;
        @Generated
        private Boolean ofdmaEnable2g;
        @Generated
        private Boolean ofdmaEnable5g;
        @Generated
        private Boolean ofdmaEnable5g1;
        @Generated
        private Boolean ofdmaEnable5g2;
        @Generated
        private Boolean ofdmaEnable6g;

        @Generated
        public B hwOffloadEnable(Boolean hwOffloadEnable) {
            this.hwOffloadEnable = hwOffloadEnable;
            return this.self();
        }

        @Deprecated
        @Generated
        public B lldpEnable(Boolean lldpEnable) {
            this.lldpEnable = lldpEnable;
            return this.self();
        }

        @Generated
        public B lldpSetting(Integer lldpSetting) {
            this.lldpSetting = lldpSetting;
            return this.self();
        }

        @Generated
        public B poeSettings(List<OsgPortPoeOpenApiVO> poeSettings) {
            this.poeSettings = poeSettings;
            return this.self();
        }

        @Generated
        public B echoServer(String echoServer) {
            this.echoServer = echoServer;
            return this.self();
        }

        @Generated
        public B lbSetting2g(ApLoadBalanceOpenApiVO lbSetting2g) {
            this.lbSetting2g = lbSetting2g;
            return this.self();
        }

        @Generated
        public B lbSetting5g(ApLoadBalanceOpenApiVO lbSetting5g) {
            this.lbSetting5g = lbSetting5g;
            return this.self();
        }

        @Generated
        public B lbSetting5g1(ApLoadBalanceOpenApiVO lbSetting5g1) {
            this.lbSetting5g1 = lbSetting5g1;
            return this.self();
        }

        @Generated
        public B lbSetting5g2(ApLoadBalanceOpenApiVO lbSetting5g2) {
            this.lbSetting5g2 = lbSetting5g2;
            return this.self();
        }

        @Generated
        public B lbSetting6g(ApLoadBalanceOpenApiVO lbSetting6g) {
            this.lbSetting6g = lbSetting6g;
            return this.self();
        }

        @Generated
        public B rssiSetting2g(ApRssiThresholdOpenApiVO rssiSetting2g) {
            this.rssiSetting2g = rssiSetting2g;
            return this.self();
        }

        @Generated
        public B rssiSetting5g(ApRssiThresholdOpenApiVO rssiSetting5g) {
            this.rssiSetting5g = rssiSetting5g;
            return this.self();
        }

        @Generated
        public B rssiSetting5g1(ApRssiThresholdOpenApiVO rssiSetting5g1) {
            this.rssiSetting5g1 = rssiSetting5g1;
            return this.self();
        }

        @Generated
        public B rssiSetting5g2(ApRssiThresholdOpenApiVO rssiSetting5g2) {
            this.rssiSetting5g2 = rssiSetting5g2;
            return this.self();
        }

        @Generated
        public B rssiSetting6g(ApRssiThresholdOpenApiVO rssiSetting6g) {
            this.rssiSetting6g = rssiSetting6g;
            return this.self();
        }

        @Generated
        public B qosSetting2g(ApQosOpenApiVO qosSetting2g) {
            this.qosSetting2g = qosSetting2g;
            return this.self();
        }

        @Generated
        public B qosSetting5g(ApQosOpenApiVO qosSetting5g) {
            this.qosSetting5g = qosSetting5g;
            return this.self();
        }

        @Generated
        public B qosSetting5g1(ApQosOpenApiVO qosSetting5g1) {
            this.qosSetting5g1 = qosSetting5g1;
            return this.self();
        }

        @Generated
        public B qosSetting5g2(ApQosOpenApiVO qosSetting5g2) {
            this.qosSetting5g2 = qosSetting5g2;
            return this.self();
        }

        @Generated
        public B qosSetting6g(ApQosOpenApiVO qosSetting6g) {
            this.qosSetting6g = qosSetting6g;
            return this.self();
        }

        @Generated
        public B ofdmaEnable2g(Boolean ofdmaEnable2g) {
            this.ofdmaEnable2g = ofdmaEnable2g;
            return this.self();
        }

        @Generated
        public B ofdmaEnable5g(Boolean ofdmaEnable5g) {
            this.ofdmaEnable5g = ofdmaEnable5g;
            return this.self();
        }

        @Generated
        public B ofdmaEnable5g1(Boolean ofdmaEnable5g1) {
            this.ofdmaEnable5g1 = ofdmaEnable5g1;
            return this.self();
        }

        @Generated
        public B ofdmaEnable5g2(Boolean ofdmaEnable5g2) {
            this.ofdmaEnable5g2 = ofdmaEnable5g2;
            return this.self();
        }

        @Generated
        public B ofdmaEnable6g(Boolean ofdmaEnable6g) {
            this.ofdmaEnable6g = ofdmaEnable6g;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "OsgConfigAdvancedOpenApiVO.OsgConfigAdvancedOpenApiVOBuilder(hwOffloadEnable=" + this.hwOffloadEnable + ", lldpEnable=" + this.lldpEnable + ", lldpSetting=" + this.lldpSetting + ", poeSettings=" + this.poeSettings + ", echoServer=" + this.echoServer + ", lbSetting2g=" + this.lbSetting2g + ", lbSetting5g=" + this.lbSetting5g + ", lbSetting5g1=" + this.lbSetting5g1 + ", lbSetting5g2=" + this.lbSetting5g2 + ", lbSetting6g=" + this.lbSetting6g + ", rssiSetting2g=" + this.rssiSetting2g + ", rssiSetting5g=" + this.rssiSetting5g + ", rssiSetting5g1=" + this.rssiSetting5g1 + ", rssiSetting5g2=" + this.rssiSetting5g2 + ", rssiSetting6g=" + this.rssiSetting6g + ", qosSetting2g=" + this.qosSetting2g + ", qosSetting5g=" + this.qosSetting5g + ", qosSetting5g1=" + this.qosSetting5g1 + ", qosSetting5g2=" + this.qosSetting5g2 + ", qosSetting6g=" + this.qosSetting6g + ", ofdmaEnable2g=" + this.ofdmaEnable2g + ", ofdmaEnable5g=" + this.ofdmaEnable5g + ", ofdmaEnable5g1=" + this.ofdmaEnable5g1 + ", ofdmaEnable5g2=" + this.ofdmaEnable5g2 + ", ofdmaEnable6g=" + this.ofdmaEnable6g + ")";
        }
    }

    @Generated
    private static final class OsgConfigAdvancedOpenApiVOBuilderImpl
    extends OsgConfigAdvancedOpenApiVOBuilder<OsgConfigAdvancedOpenApiVO, OsgConfigAdvancedOpenApiVOBuilderImpl> {
        @Generated
        private OsgConfigAdvancedOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected OsgConfigAdvancedOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public OsgConfigAdvancedOpenApiVO build() {
            return new OsgConfigAdvancedOpenApiVO(this);
        }
    }
}

