/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.analyze.api.openapi;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.analyze.api.dto.PackageCaptureVO;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="PackageCaptureConfig")
public class PackageCaptureOpenApiVO {
    @Range(min=1L, max=300L, message="Parameter [duration] should from 1 to 300")
    @Schema(name="duration", description="Packet capture duration, in seconds.")
    private @Range(min=1L, max=300L, message="Parameter [duration] should from 1 to 300") Integer duration;
    @NumberSet(value={0, 1, 2}, message="Parameter [interfaceType] should be 0, 1 or 2")
    @Schema(name="interfaceType", description="Interface type. 0: Wired; 1: Wireless; 2: LAN Network.")
    private Integer interfaceType;
    @Schema(name="singlePackageSize", description="Single package size, in bytes.")
    private Long singlePackageSize;
    @NumberSet(value={0, 1, 2, 3}, message="Parameter [channel] should be 0,1,2,3")
    @Schema(name="channel", description="(Wireless)  0: 2.4GHz  1: 5GHz-1  2:5GHz-2 3: 6GHz")
    private Integer channel;
    @Schema(name="interfaceName", description="Interface name.")
    private String interfaceName;
    @Schema(name="interfaceId", description="Interface ID, for example: if interfaceType is network, interfaceId should be LAN network ID. LAN Network can be created using 'Create LAN network' interface, and LAN Network ID can be obtained from 'Get LAN network list' interface.")
    private String interfaceId;
    @Schema(name="filterRules", description="Filter rules.")
    private String filterRules;
    @Schema(name="captureMode", description="Capture mode. 0: Local packet capture; 1: Flow-mode packet capture.")
    private Integer captureMode;
    @Schema(name="arChannel", description="Channel.")
    private Integer arChannel;
    @Schema(name="otaFilterRules", description="Filter rules of air interface packet capture.")
    private String otaFilterRules;
    @Schema(name="srcMac", description="Source MAC address of the packet.")
    @a
    private String srcMac;
    @Schema(name="destMac", description="Destination MAC address of the packet.")
    @a
    private String destMac;
    @Schema(name="srcMac", description="Source L4 port of the packet.")
    private Integer srcPort;
    @Schema(name="destPort", description="Destination L4 port of the packet.")
    private Integer destPort;
    @Schema(name="srcIp", description="IP address of the message sender.")
    private String srcIp;
    @Schema(name="destIp", description="Destination IP address of the packet.")
    private String destIp;
    @Schema(name="protocol", description="Packet type/protocol. It's required when a Switch captures packets.")
    private Integer protocol;
    @Schema(name="stack", description="Whether the device supports stacking.")
    private Boolean stack;
    @Schema(name="unit", description="Equipment unit ID.")
    private Integer unit;

    public PackageCaptureVO toVO() {
        PackageCaptureVO packageCaptureVO = new PackageCaptureVO();
        packageCaptureVO.setDuration(this.getDuration());
        packageCaptureVO.setInterfaceType(this.getInterfaceType());
        packageCaptureVO.setSinglePackageSize(this.getSinglePackageSize());
        packageCaptureVO.setChannel(this.getChannel());
        packageCaptureVO.setInterfaceName(this.getInterfaceName());
        packageCaptureVO.setInterfaceId(this.getInterfaceId());
        packageCaptureVO.setFilterRules(this.getFilterRules());
        packageCaptureVO.setCaptureMode(this.getCaptureMode());
        packageCaptureVO.setArChannel(this.getArChannel());
        packageCaptureVO.setOtaFilterRules(this.getOtaFilterRules());
        packageCaptureVO.setSrcMac(this.getSrcMac());
        packageCaptureVO.setDestMac(this.getDestMac());
        packageCaptureVO.setSrcPort(this.getSrcPort());
        packageCaptureVO.setDestPort(this.getDestPort());
        packageCaptureVO.setSrcIp(this.getSrcIp());
        packageCaptureVO.setDestIp(this.getDestIp());
        packageCaptureVO.setProtocol(this.getProtocol());
        packageCaptureVO.setStack(this.getStack());
        packageCaptureVO.setUnit(this.getUnit());
        return packageCaptureVO;
    }

    @Generated
    public PackageCaptureOpenApiVO() {
    }

    @Generated
    public PackageCaptureOpenApiVO(Integer duration, Integer interfaceType, Long singlePackageSize, Integer channel, String interfaceName, String interfaceId, String filterRules, Integer captureMode, Integer arChannel, String otaFilterRules, String srcMac, String destMac, Integer srcPort, Integer destPort, String srcIp, String destIp, Integer protocol, Boolean stack, Integer unit) {
        this.duration = duration;
        this.interfaceType = interfaceType;
        this.singlePackageSize = singlePackageSize;
        this.channel = channel;
        this.interfaceName = interfaceName;
        this.interfaceId = interfaceId;
        this.filterRules = filterRules;
        this.captureMode = captureMode;
        this.arChannel = arChannel;
        this.otaFilterRules = otaFilterRules;
        this.srcMac = srcMac;
        this.destMac = destMac;
        this.srcPort = srcPort;
        this.destPort = destPort;
        this.srcIp = srcIp;
        this.destIp = destIp;
        this.protocol = protocol;
        this.stack = stack;
        this.unit = unit;
    }

    @Generated
    public Integer getDuration() {
        return this.duration;
    }

    @Generated
    public Integer getInterfaceType() {
        return this.interfaceType;
    }

    @Generated
    public Long getSinglePackageSize() {
        return this.singlePackageSize;
    }

    @Generated
    public Integer getChannel() {
        return this.channel;
    }

    @Generated
    public String getInterfaceName() {
        return this.interfaceName;
    }

    @Generated
    public String getInterfaceId() {
        return this.interfaceId;
    }

    @Generated
    public String getFilterRules() {
        return this.filterRules;
    }

    @Generated
    public Integer getCaptureMode() {
        return this.captureMode;
    }

    @Generated
    public Integer getArChannel() {
        return this.arChannel;
    }

    @Generated
    public String getOtaFilterRules() {
        return this.otaFilterRules;
    }

    @Generated
    public String getSrcMac() {
        return this.srcMac;
    }

    @Generated
    public String getDestMac() {
        return this.destMac;
    }

    @Generated
    public Integer getSrcPort() {
        return this.srcPort;
    }

    @Generated
    public Integer getDestPort() {
        return this.destPort;
    }

    @Generated
    public String getSrcIp() {
        return this.srcIp;
    }

    @Generated
    public String getDestIp() {
        return this.destIp;
    }

    @Generated
    public Integer getProtocol() {
        return this.protocol;
    }

    @Generated
    public Boolean getStack() {
        return this.stack;
    }

    @Generated
    public Integer getUnit() {
        return this.unit;
    }

    @Generated
    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    @Generated
    public void setInterfaceType(Integer interfaceType) {
        this.interfaceType = interfaceType;
    }

    @Generated
    public void setSinglePackageSize(Long singlePackageSize) {
        this.singlePackageSize = singlePackageSize;
    }

    @Generated
    public void setChannel(Integer channel) {
        this.channel = channel;
    }

    @Generated
    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    @Generated
    public void setInterfaceId(String interfaceId) {
        this.interfaceId = interfaceId;
    }

    @Generated
    public void setFilterRules(String filterRules) {
        this.filterRules = filterRules;
    }

    @Generated
    public void setCaptureMode(Integer captureMode) {
        this.captureMode = captureMode;
    }

    @Generated
    public void setArChannel(Integer arChannel) {
        this.arChannel = arChannel;
    }

    @Generated
    public void setOtaFilterRules(String otaFilterRules) {
        this.otaFilterRules = otaFilterRules;
    }

    @Generated
    public void setSrcMac(String srcMac) {
        this.srcMac = srcMac;
    }

    @Generated
    public void setDestMac(String destMac) {
        this.destMac = destMac;
    }

    @Generated
    public void setSrcPort(Integer srcPort) {
        this.srcPort = srcPort;
    }

    @Generated
    public void setDestPort(Integer destPort) {
        this.destPort = destPort;
    }

    @Generated
    public void setSrcIp(String srcIp) {
        this.srcIp = srcIp;
    }

    @Generated
    public void setDestIp(String destIp) {
        this.destIp = destIp;
    }

    @Generated
    public void setProtocol(Integer protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setStack(Boolean stack) {
        this.stack = stack;
    }

    @Generated
    public void setUnit(Integer unit) {
        this.unit = unit;
    }

    @Generated
    public String toString() {
        return "PackageCaptureOpenApiVO(duration=" + this.getDuration() + ", interfaceType=" + this.getInterfaceType() + ", singlePackageSize=" + this.getSinglePackageSize() + ", channel=" + this.getChannel() + ", interfaceName=" + this.getInterfaceName() + ", interfaceId=" + this.getInterfaceId() + ", filterRules=" + this.getFilterRules() + ", captureMode=" + this.getCaptureMode() + ", arChannel=" + this.getArChannel() + ", otaFilterRules=" + this.getOtaFilterRules() + ", srcMac=" + this.getSrcMac() + ", destMac=" + this.getDestMac() + ", srcPort=" + this.getSrcPort() + ", destPort=" + this.getDestPort() + ", srcIp=" + this.getSrcIp() + ", destIp=" + this.getDestIp() + ", protocol=" + this.getProtocol() + ", stack=" + this.getStack() + ", unit=" + this.getUnit() + ")";
    }
}

