/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.analyze.api.openapi;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.analyze.api.dto.DeviceCaptureVO;
import com.tplink.smb.omada.manager.analyze.api.dto.InterfaceInfo;
import com.tplink.smb.omada.manager.analyze.api.openapi.ChannelInfoOpenApiVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

@Schema(name="DeviceCaptureInfo")
public class DeviceCaptureOpenApiVO {
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @Schema(name="mac", description="Device MAC.")
    @a
    private String mac;
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @Schema(name="name", description="Device name.")
    private String name;
    @Schema(name="model", description="Model of device,for example:EAP225.")
    private String model;
    @Schema(name="modelVersion", description="Model version of device,for example:3.0")
    private String modelVersion;
    @Schema(name="showModel", description="Model complex shown in the front end.Ap\uff1amodel+(country)+modelVersion,EAP225(EU) v3.0  Gateway/Switch\uff1amodel+modelVersion,Osg v3.0")
    private String showModel;
    @PII(strategy=PIIMaskStrategy.HASH)
    @Schema(name="ip", description="IP Address.")
    private String ip;
    @Schema(name="supportCapture", description="Parameter [supportCapture] indicates whether the device supports packet capture.")
    private Boolean supportCapture;
    @Schema(name="support2g", description="Whether the device supports 2.4GHz.")
    private Boolean support2g;
    @Schema(name="support5g", description="Whether the device supports 5GHz.")
    private Boolean support5g;
    @Schema(name="support5g2", description="Whether the device supports 5GHz frequency splitting into two parts.")
    private Boolean support5g2;
    @Schema(name="support6g", description="Whether the device supports 6GHz.")
    private Boolean support6g;
    @Schema(name="firmwareVersion", description="Device firmware version.")
    private String firmwareVersion;
    @Schema(name="supportLanCapture", description="Parameter [supportLanCapture] indicates whether the device supports LAN port packet capture.")
    private Boolean supportLanCapture;
    @Schema(name="interfaces", description="Interface info.")
    private List<InterfaceInfo> interfaces;
    @Schema(name="deviceSeriesType", description="Device type: 0: Advanced; 1: Pro.")
    private Integer deviceSeriesType;
    @Schema(name="type", description="Device Type.")
    private String type;
    @Schema(name="stack", description="Parameter [stack] indicates whether the device supports stacking.")
    private Boolean stack;
    @Schema(name="stackId", description="Stack ID.")
    private String stackId;
    @Schema(name="supportOTACapture", description="Parameter [supportOTACapture] indicates whether the device supports air interface packet capture and flow-mode packet capture.")
    private Boolean supportOTACapture;
    @Schema(name="currentChannel2g", description="Current channel of 2.4 GHz.")
    private Integer currentChannel2g;
    @Schema(name="channelList2g", description="Channel list that device supports in 2.4 GHz.")
    private List<ChannelInfoOpenApiVO> channelList2g;
    @Schema(name="currentChannel5g", description="Current channel of 5 GHz.")
    private Integer currentChannel5g;
    @Schema(name="channelList5g", description="Channel list that device supports in 5 GHz.")
    private List<ChannelInfoOpenApiVO> channelList5g;
    @Schema(name="currentChannel5g2", description="Current channel of 5 GHz(2).")
    private Integer currentChannel5g2;
    @Schema(name="channelList5g2", description="Channel list that device supports in 5 GHz(2).")
    private List<ChannelInfoOpenApiVO> channelList5g2;
    @Schema(name="currentChannel6g", description="Current channel of 6 GHz.")
    private Integer currentChannel6g;
    @Schema(name="channelList6g", description="Channel list that device supports in 6 GHz.")
    private List<ChannelInfoOpenApiVO> channelList6g;
    @Schema(name="fileSize", description="Size limit of the captured file, in MB.")
    private Integer fileSize;
    @Schema(name="supportStreamCapture", description="Parameter [supportStreamCapture] indicates whether the device supports flow-mode packet capture.")
    private Boolean supportStreamCapture;
    @Schema(name="supportScanRadio", description="Parameter [supportScanRadio] indicates whether the device has independent radio frequency capabilities.")
    private Boolean supportScanRadio;

    public static DeviceCaptureOpenApiVO buildByVO(@Nonnull DeviceCaptureVO deviceCaptureVO) {
        DeviceCaptureOpenApiVO deviceCaptureOpenApiVO = new DeviceCaptureOpenApiVO();
        deviceCaptureOpenApiVO.setMac(deviceCaptureVO.getMac());
        deviceCaptureOpenApiVO.setName(deviceCaptureVO.getName());
        deviceCaptureOpenApiVO.setModel(deviceCaptureVO.getModel());
        deviceCaptureOpenApiVO.setModelVersion(deviceCaptureVO.getModelVersion());
        deviceCaptureOpenApiVO.setShowModel(deviceCaptureVO.getShowModel());
        deviceCaptureOpenApiVO.setIp(deviceCaptureVO.getIp());
        deviceCaptureOpenApiVO.setSupportCapture(deviceCaptureVO.getSupportCapture());
        deviceCaptureOpenApiVO.setSupport2g(deviceCaptureVO.getSupport2g());
        deviceCaptureOpenApiVO.setSupport5g(deviceCaptureVO.getSupport5g());
        deviceCaptureOpenApiVO.setSupport5g2(deviceCaptureVO.getSupport5g2());
        deviceCaptureOpenApiVO.setSupport6g(deviceCaptureVO.getSupport6g());
        deviceCaptureOpenApiVO.setFirmwareVersion(deviceCaptureVO.getFirmwareVersion());
        deviceCaptureOpenApiVO.setSupportLanCapture(deviceCaptureVO.getSupportLanCapture());
        deviceCaptureOpenApiVO.setInterfaces(deviceCaptureVO.getInterfaces());
        deviceCaptureOpenApiVO.setDeviceSeriesType(deviceCaptureVO.getDeviceSeriesType());
        deviceCaptureOpenApiVO.setType(deviceCaptureVO.getType());
        deviceCaptureOpenApiVO.setStack(deviceCaptureVO.getStack());
        deviceCaptureOpenApiVO.setStackId(deviceCaptureVO.getStackId());
        deviceCaptureOpenApiVO.setSupportOTACapture(deviceCaptureVO.getSupportOTACapture());
        deviceCaptureOpenApiVO.setCurrentChannel2g(deviceCaptureVO.getCurrentChannel2g());
        deviceCaptureOpenApiVO.setChannelList2g(CollectionUtils.isEmpty((Collection)deviceCaptureVO.getChannelList2g()) ? new ArrayList<ChannelInfoOpenApiVO>() : deviceCaptureVO.getChannelList2g().stream().map(ChannelInfoOpenApiVO::fromVO).collect(Collectors.toList()));
        deviceCaptureOpenApiVO.setCurrentChannel5g(deviceCaptureVO.getCurrentChannel5g());
        deviceCaptureOpenApiVO.setChannelList5g(CollectionUtils.isEmpty((Collection)deviceCaptureVO.getChannelList5g()) ? new ArrayList<ChannelInfoOpenApiVO>() : deviceCaptureVO.getChannelList5g().stream().map(ChannelInfoOpenApiVO::fromVO).collect(Collectors.toList()));
        deviceCaptureOpenApiVO.setCurrentChannel5g2(deviceCaptureVO.getCurrentChannel5g2());
        deviceCaptureOpenApiVO.setChannelList5g2(CollectionUtils.isEmpty((Collection)deviceCaptureVO.getChannelList5g2()) ? new ArrayList<ChannelInfoOpenApiVO>() : deviceCaptureVO.getChannelList5g2().stream().map(ChannelInfoOpenApiVO::fromVO).collect(Collectors.toList()));
        deviceCaptureOpenApiVO.setCurrentChannel6g(deviceCaptureVO.getCurrentChannel6g());
        deviceCaptureOpenApiVO.setChannelList6g(CollectionUtils.isEmpty((Collection)deviceCaptureVO.getChannelList6g()) ? new ArrayList<ChannelInfoOpenApiVO>() : deviceCaptureVO.getChannelList6g().stream().map(ChannelInfoOpenApiVO::fromVO).collect(Collectors.toList()));
        deviceCaptureOpenApiVO.setFileSize(deviceCaptureVO.getFileSize());
        deviceCaptureOpenApiVO.setSupportStreamCapture(deviceCaptureVO.getSupportStreamCapture());
        deviceCaptureOpenApiVO.setSupportScanRadio(deviceCaptureVO.getSupportScanRadio());
        return deviceCaptureOpenApiVO;
    }

    @Generated
    public DeviceCaptureOpenApiVO() {
    }

    @Generated
    public DeviceCaptureOpenApiVO(String mac, String name, String model, String modelVersion, String showModel, String ip, Boolean supportCapture, Boolean support2g, Boolean support5g, Boolean support5g2, Boolean support6g, String firmwareVersion, Boolean supportLanCapture, List<InterfaceInfo> interfaces, Integer deviceSeriesType, String type, Boolean stack, String stackId, Boolean supportOTACapture, Integer currentChannel2g, List<ChannelInfoOpenApiVO> channelList2g, Integer currentChannel5g, List<ChannelInfoOpenApiVO> channelList5g, Integer currentChannel5g2, List<ChannelInfoOpenApiVO> channelList5g2, Integer currentChannel6g, List<ChannelInfoOpenApiVO> channelList6g, Integer fileSize, Boolean supportStreamCapture, Boolean supportScanRadio) {
        this.mac = mac;
        this.name = name;
        this.model = model;
        this.modelVersion = modelVersion;
        this.showModel = showModel;
        this.ip = ip;
        this.supportCapture = supportCapture;
        this.support2g = support2g;
        this.support5g = support5g;
        this.support5g2 = support5g2;
        this.support6g = support6g;
        this.firmwareVersion = firmwareVersion;
        this.supportLanCapture = supportLanCapture;
        this.interfaces = interfaces;
        this.deviceSeriesType = deviceSeriesType;
        this.type = type;
        this.stack = stack;
        this.stackId = stackId;
        this.supportOTACapture = supportOTACapture;
        this.currentChannel2g = currentChannel2g;
        this.channelList2g = channelList2g;
        this.currentChannel5g = currentChannel5g;
        this.channelList5g = channelList5g;
        this.currentChannel5g2 = currentChannel5g2;
        this.channelList5g2 = channelList5g2;
        this.currentChannel6g = currentChannel6g;
        this.channelList6g = channelList6g;
        this.fileSize = fileSize;
        this.supportStreamCapture = supportStreamCapture;
        this.supportScanRadio = supportScanRadio;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getModelVersion() {
        return this.modelVersion;
    }

    @Generated
    public String getShowModel() {
        return this.showModel;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public Boolean getSupportCapture() {
        return this.supportCapture;
    }

    @Generated
    public Boolean getSupport2g() {
        return this.support2g;
    }

    @Generated
    public Boolean getSupport5g() {
        return this.support5g;
    }

    @Generated
    public Boolean getSupport5g2() {
        return this.support5g2;
    }

    @Generated
    public Boolean getSupport6g() {
        return this.support6g;
    }

    @Generated
    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    @Generated
    public Boolean getSupportLanCapture() {
        return this.supportLanCapture;
    }

    @Generated
    public List<InterfaceInfo> getInterfaces() {
        return this.interfaces;
    }

    @Generated
    public Integer getDeviceSeriesType() {
        return this.deviceSeriesType;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Boolean getStack() {
        return this.stack;
    }

    @Generated
    public String getStackId() {
        return this.stackId;
    }

    @Generated
    public Boolean getSupportOTACapture() {
        return this.supportOTACapture;
    }

    @Generated
    public Integer getCurrentChannel2g() {
        return this.currentChannel2g;
    }

    @Generated
    public List<ChannelInfoOpenApiVO> getChannelList2g() {
        return this.channelList2g;
    }

    @Generated
    public Integer getCurrentChannel5g() {
        return this.currentChannel5g;
    }

    @Generated
    public List<ChannelInfoOpenApiVO> getChannelList5g() {
        return this.channelList5g;
    }

    @Generated
    public Integer getCurrentChannel5g2() {
        return this.currentChannel5g2;
    }

    @Generated
    public List<ChannelInfoOpenApiVO> getChannelList5g2() {
        return this.channelList5g2;
    }

    @Generated
    public Integer getCurrentChannel6g() {
        return this.currentChannel6g;
    }

    @Generated
    public List<ChannelInfoOpenApiVO> getChannelList6g() {
        return this.channelList6g;
    }

    @Generated
    public Integer getFileSize() {
        return this.fileSize;
    }

    @Generated
    public Boolean getSupportStreamCapture() {
        return this.supportStreamCapture;
    }

    @Generated
    public Boolean getSupportScanRadio() {
        return this.supportScanRadio;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    @Generated
    public void setShowModel(String showModel) {
        this.showModel = showModel;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setSupportCapture(Boolean supportCapture) {
        this.supportCapture = supportCapture;
    }

    @Generated
    public void setSupport2g(Boolean support2g) {
        this.support2g = support2g;
    }

    @Generated
    public void setSupport5g(Boolean support5g) {
        this.support5g = support5g;
    }

    @Generated
    public void setSupport5g2(Boolean support5g2) {
        this.support5g2 = support5g2;
    }

    @Generated
    public void setSupport6g(Boolean support6g) {
        this.support6g = support6g;
    }

    @Generated
    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    @Generated
    public void setSupportLanCapture(Boolean supportLanCapture) {
        this.supportLanCapture = supportLanCapture;
    }

    @Generated
    public void setInterfaces(List<InterfaceInfo> interfaces) {
        this.interfaces = interfaces;
    }

    @Generated
    public void setDeviceSeriesType(Integer deviceSeriesType) {
        this.deviceSeriesType = deviceSeriesType;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setStack(Boolean stack) {
        this.stack = stack;
    }

    @Generated
    public void setStackId(String stackId) {
        this.stackId = stackId;
    }

    @Generated
    public void setSupportOTACapture(Boolean supportOTACapture) {
        this.supportOTACapture = supportOTACapture;
    }

    @Generated
    public void setCurrentChannel2g(Integer currentChannel2g) {
        this.currentChannel2g = currentChannel2g;
    }

    @Generated
    public void setChannelList2g(List<ChannelInfoOpenApiVO> channelList2g) {
        this.channelList2g = channelList2g;
    }

    @Generated
    public void setCurrentChannel5g(Integer currentChannel5g) {
        this.currentChannel5g = currentChannel5g;
    }

    @Generated
    public void setChannelList5g(List<ChannelInfoOpenApiVO> channelList5g) {
        this.channelList5g = channelList5g;
    }

    @Generated
    public void setCurrentChannel5g2(Integer currentChannel5g2) {
        this.currentChannel5g2 = currentChannel5g2;
    }

    @Generated
    public void setChannelList5g2(List<ChannelInfoOpenApiVO> channelList5g2) {
        this.channelList5g2 = channelList5g2;
    }

    @Generated
    public void setCurrentChannel6g(Integer currentChannel6g) {
        this.currentChannel6g = currentChannel6g;
    }

    @Generated
    public void setChannelList6g(List<ChannelInfoOpenApiVO> channelList6g) {
        this.channelList6g = channelList6g;
    }

    @Generated
    public void setFileSize(Integer fileSize) {
        this.fileSize = fileSize;
    }

    @Generated
    public void setSupportStreamCapture(Boolean supportStreamCapture) {
        this.supportStreamCapture = supportStreamCapture;
    }

    @Generated
    public void setSupportScanRadio(Boolean supportScanRadio) {
        this.supportScanRadio = supportScanRadio;
    }

    @Generated
    public String toString() {
        return "DeviceCaptureOpenApiVO(mac=" + this.getMac() + ", name=" + this.getName() + ", model=" + this.getModel() + ", modelVersion=" + this.getModelVersion() + ", showModel=" + this.getShowModel() + ", ip=" + this.getIp() + ", supportCapture=" + this.getSupportCapture() + ", support2g=" + this.getSupport2g() + ", support5g=" + this.getSupport5g() + ", support5g2=" + this.getSupport5g2() + ", support6g=" + this.getSupport6g() + ", firmwareVersion=" + this.getFirmwareVersion() + ", supportLanCapture=" + this.getSupportLanCapture() + ", interfaces=" + this.getInterfaces() + ", deviceSeriesType=" + this.getDeviceSeriesType() + ", type=" + this.getType() + ", stack=" + this.getStack() + ", stackId=" + this.getStackId() + ", supportOTACapture=" + this.getSupportOTACapture() + ", currentChannel2g=" + this.getCurrentChannel2g() + ", channelList2g=" + this.getChannelList2g() + ", currentChannel5g=" + this.getCurrentChannel5g() + ", channelList5g=" + this.getChannelList5g() + ", currentChannel5g2=" + this.getCurrentChannel5g2() + ", channelList5g2=" + this.getChannelList5g2() + ", currentChannel6g=" + this.getCurrentChannel6g() + ", channelList6g=" + this.getChannelList6g() + ", fileSize=" + this.getFileSize() + ", supportStreamCapture=" + this.getSupportStreamCapture() + ", supportScanRadio=" + this.getSupportScanRadio() + ")";
    }
}

