/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.xslt;

import java.io.FileReader;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.kabeja.xml.AbstractSAXFilter;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SAXXSLTFilter
extends AbstractSAXFilter {
    public static final String PROPERTY_XSLTSTYLESHEET = "stylesheet";
    protected ContentHandler handler;
    protected String xsltSource;

    public void startDocument() throws SAXException {
        if (this.properties.containsKey(PROPERTY_XSLTSTYLESHEET)) {
            try {
                SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
                FileReader reader = new FileReader((String)this.properties.get(PROPERTY_XSLTSTYLESHEET));
                SAXSource src = new SAXSource(new InputSource(reader));
                TransformerHandler f = factory.newTransformerHandler(src);
                this.setParameters(f);
                f.setResult(new SAXResult(this.handler));
                super.setContentHandler(f);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        super.startDocument();
    }

    public void setContentHandler(ContentHandler handler) {
        this.handler = handler;
        super.setContentHandler(handler);
    }

    protected void setParameters(TransformerHandler h) {
        Transformer tf = h.getTransformer();
        Iterator i = this.properties.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (PROPERTY_XSLTSTYLESHEET.equals(i)) continue;
            tf.setParameter(name, this.properties.get(name));
        }
    }

    public Map getProperties() {
        return this.properties;
    }
}

