/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.ui.impl;

import de.miethxml.toolkit.ui.SelectorComponent;
import java.awt.CardLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.kabeja.processing.ProcessingManager;
import org.kabeja.ui.Application;
import org.kabeja.ui.ApplicationMenuBar;
import org.kabeja.ui.ApplicationToolBar;
import org.kabeja.ui.Component;
import org.kabeja.ui.ProcessingUIComponent;
import org.kabeja.ui.ServiceManager;
import org.kabeja.ui.Serviceable;
import org.kabeja.ui.Startable;
import org.kabeja.ui.ViewComponent;
import org.kabeja.ui.impl.AboutAction;
import org.kabeja.ui.impl.Messages;

public class ProcessingUI
implements Serviceable,
Startable,
ProcessingUIComponent,
ApplicationToolBar,
ApplicationMenuBar {
    protected ServiceManager serviceManager;
    protected ProcessingManager manager;
    protected JFrame frame;
    protected List components = new ArrayList();
    private JPanel mainPanel;
    private CardLayout mainContainer;
    private SelectorComponent selector;
    private JPanel panel;
    private JToolBar toolbar;
    private JMenuBar menubar;
    private Map menus = new HashMap();
    private Application application;

    protected void initialize() {
        this.frame = new JFrame(Messages.getString("ProcessingUI.title"));
        this.frame.setDefaultCloseOperation(3);
        this.panel = new JPanel();
        this.panel.setBorder(BorderFactory.createEmptyBorder());
        this.mainContainer = new CardLayout();
        this.mainPanel = new JPanel(this.mainContainer);
        this.toolbar = new JToolBar();
        this.toolbar.add(Box.createHorizontalGlue());
        this.selector = new SelectorComponent();
        this.toolbar.add(this.selector.getView());
        this.frame.getContentPane().add((java.awt.Component)this.toolbar, "North");
        this.menubar = new JMenuBar();
        this.frame.setJMenuBar(this.menubar);
        this.menubar.add(Box.createHorizontalGlue());
        JMenu menu = new JMenu(Messages.getString("ProcessingUI.menu.help"));
        menu.add(new AboutAction());
        this.menubar.add(menu);
        this.menus.put("menu.help", menu);
        menu = new JMenu(Messages.getString("ProcessingUI.menu.file"));
        menu.add(new AbstractAction(Messages.getString("ProcessingUI.menu.file.exit")){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ProcessingUI.this.shutdown();
                    }
                });
            }
        });
        this.setMenu("menu.file", menu);
        this.frame.getContentPane().add((java.awt.Component)this.mainPanel, "Center");
        this.frame.setSize(700, 620);
        this.frame.validate();
    }

    public void setVisible(boolean b) {
        if (b) {
            this.frame.setVisible(true);
        } else {
            this.frame.setVisible(false);
        }
    }

    public void addViewComponent(ViewComponent component) {
        int index = this.components.size();
        this.components.add(component);
        JComponent view = component.getView();
        if (this.mainPanel.getMinimumSize().getWidth() < view.getPreferredSize().getWidth()) {
            this.mainPanel.setPreferredSize(view.getPreferredSize());
        }
        this.mainPanel.add((java.awt.Component)view, "" + index);
        SwitchAction action = new SwitchAction(component.getTitle(), index);
        this.selector.addAction(action);
    }

    public void setServiceManager(ServiceManager manager) {
        this.serviceManager = manager;
        Component[] objects = this.serviceManager.getServiceComponents(Application.SERVICE);
        this.application = (Application)objects[0];
        this.initialize();
        objects = this.serviceManager.getServiceComponents(ViewComponent.SERVICE);
        for (int i = 0; i < objects.length; ++i) {
            this.addViewComponent((ViewComponent)objects[i]);
        }
    }

    public void setProcessingManager(ProcessingManager manager) {
        this.manager = manager;
    }

    public void start() {
        this.frame.setVisible(true);
    }

    public void stop() {
        this.frame.setVisible(false);
    }

    public void addAction(Action action) {
        JButton button = new JButton(action);
        button.setToolTipText(button.getText());
        button.setText("");
        this.addAction(button);
    }

    public void addAction(java.awt.Component component) {
        if (this.toolbar.getComponentCount() > 1) {
            this.toolbar.add(component, this.toolbar.getComponentCount() - 2);
        } else {
            this.toolbar.add(component);
        }
    }

    public boolean hasMenu(String id) {
        return this.menus.containsKey(id);
    }

    public void setAction(String menuID, Action action) {
        this.setJMenuItem(menuID, new JMenuItem(action));
    }

    public void setJMenuItem(String menuID, JMenuItem item) {
        if (this.hasMenu(menuID)) {
            JMenu menu = (JMenu)this.menus.get(menuID);
            if (menuID.equals("menu.file")) {
                menu.add((java.awt.Component)item, 0);
            } else {
                menu.add(item);
            }
        }
    }

    public void setMenu(String menuID, JMenu menu) {
        if (!this.hasMenu(menuID)) {
            this.menus.put(menuID, menu);
            this.menubar.add((java.awt.Component)menu, this.menubar.getComponentCount() - 2);
        }
    }

    protected void shutdown() {
        this.application.stop();
    }

    public class SwitchAction
    extends AbstractAction {
        int index;

        public SwitchAction(String label, int index) {
            super(label);
            this.index = index;
        }

        public void actionPerformed(ActionEvent e) {
            ProcessingUI.this.mainContainer.show(ProcessingUI.this.mainPanel, "" + this.index);
        }
    }
}

