/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.ui.impl;

import de.miethxml.toolkit.ui.PanelFactory;
import de.miethxml.toolkit.ui.UIUtils;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import org.kabeja.processing.ProcessingManager;
import org.kabeja.ui.model.ProcessingTreeModelPresenter;

public class ProcessingTreeViewBuilder {
    protected ProcessingManager manager;
    protected JTree tree;

    public ProcessingTreeViewBuilder(ProcessingManager manager) {
        this.manager = manager;
    }

    public JComponent getView() {
        JSplitPane sp = PanelFactory.createOneTouchSplitPane();
        this.tree = new JTree(new ProcessingTreeModelPresenter(this.manager));
        this.tree.setEditable(true);
        this.tree.setDragEnabled(true);
        this.tree.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.tree.setRowHeight(0);
        JScrollPane scroll = new JScrollPane(this.tree);
        scroll.setBorder(BorderFactory.createEmptyBorder());
        JPanel panel = PanelFactory.createTitledPanel((JComponent)scroll, "ProcessingTree", "Options", this.createBorderMenu());
        panel.setPreferredSize(new Dimension(150, 350));
        sp.setLeftComponent(panel);
        JPanel panel2 = PanelFactory.createTitledPanel(new JPanel(), "Property Editor");
        panel2.setPreferredSize(new Dimension(150, 70));
        sp.setRightComponent(panel2);
        return sp;
    }

    private JPopupMenu createBorderMenu() {
        JPopupMenu bordermenu = new JPopupMenu();
        JMenuItem item = new JMenuItem("Expand All", new ImageIcon(UIUtils.resourceToBytes(this.getClass(), "/icons/expand_all.gif")));
        item.setMnemonic('E');
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (int row = 0; row < ProcessingTreeViewBuilder.this.tree.getRowCount(); ++row) {
                    ProcessingTreeViewBuilder.this.tree.expandRow(row);
                }
            }
        });
        bordermenu.add(item);
        item = new JMenuItem("Collapse All", new ImageIcon(UIUtils.resourceToBytes(this.getClass(), "/icons/collapse_all.gif")));
        item.setMnemonic('C');
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (int row = ProcessingTreeViewBuilder.this.tree.getRowCount() - 1; row > 0; --row) {
                    ProcessingTreeViewBuilder.this.tree.collapseRow(row);
                }
            }
        });
        bordermenu.add(item);
        return bordermenu;
    }
}

