/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.ui.impl;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import org.kabeja.processing.ProcessingManager;
import org.kabeja.tools.SAXProcessingManagerBuilder;
import org.kabeja.ui.impl.Messages;
import org.kabeja.ui.impl.ServiceContainer;

public class OpenProcessingAction
extends AbstractAction {
    protected String baseDir = "";
    protected ServiceContainer container;

    public OpenProcessingAction(ServiceContainer container) {
        super(Messages.getString("OpenProcessingAction.menuitem"));
        this.putValue("ShortDescription", Messages.getString("OpenProcessingAction.menuitem.description"));
        this.container = container;
    }

    public void actionPerformed(ActionEvent e) {
        Thread t = new Thread(new Runnable(){

            public void run() {
                OpenProcessingAction.this.openProcessing();
            }
        });
        t.start();
    }

    protected void openProcessing() {
        JFileChooser fc = new JFileChooser(this.baseDir);
        fc.setFileSelectionMode(0);
        int value = fc.showOpenDialog(null);
        if (value == 0) {
            File file = fc.getSelectedFile();
            try {
                ProcessingManager m = SAXProcessingManagerBuilder.buildFromStream(new FileInputStream(file));
                this.container.setProcessingManager(m);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

