/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.tools;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.kabeja.dxf.DXFStyle;

public class FontManager {
    private static FontManager instance = new FontManager();
    private String fontDescription = "conf/font.properties";
    private Map<String, String> fontProperties = new HashMap<String, String>();
    private Map<String, String> replaceTable = new HashMap<String, String>();
    private Pattern UNDERSCORE_ENDING_PATTERN = Pattern.compile("([^_]*)(_*)", 2);

    private FontManager() {
        this.loadFontDescription();
    }

    public void setFontDescription(String file) {
        this.fontDescription = file;
        this.loadFontDescription();
    }

    private void loadFontDescription() {
        this.fontProperties.clear();
        try {
            InputStream stream = this.getClass().getResourceAsStream(this.fontDescription);
            if (stream == null) {
                try {
                    stream = new FileInputStream(this.fontDescription);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (stream != null) {
                BufferedReader in = new BufferedReader(new InputStreamReader(stream));
                String line = null;
                while ((line = in.readLine()) != null) {
                    int index = line.indexOf("=");
                    if (index < 0) continue;
                    String font = line.substring(0, index).trim().toLowerCase();
                    String svgFont = line.substring(index + 1).trim();
                    this.fontProperties.put(font, svgFont);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FontManager getInstance() {
        return instance;
    }

    public String hasFontDescription(String fontName) {
        if (StringUtils.isEmpty((CharSequence)fontName)) {
            return null;
        }
        if (this.fontProperties.containsKey(fontName)) {
            return fontName;
        }
        String alternativeFont = this.doEducatedGuess(fontName);
        if (alternativeFont != null) {
            return alternativeFont;
        }
        alternativeFont = this.doReplacement(fontName);
        if (alternativeFont != null) {
            return alternativeFont;
        }
        return null;
    }

    public String getFontDescription(String svgFont) {
        return this.fontProperties.get(svgFont);
    }

    private String doEducatedGuess(String font) {
        if (this.fontProperties.containsKey(font = font.toLowerCase())) {
            return font;
        }
        if ((font.endsWith(".shx") || font.endsWith(".ttf")) && this.fontProperties.containsKey(font = font.substring(0, font.length() - 4))) {
            return font;
        }
        Matcher matcher = this.UNDERSCORE_ENDING_PATTERN.matcher(font);
        if (matcher.matches() && this.fontProperties.containsKey(font = matcher.group(1))) {
            return font;
        }
        return null;
    }

    private String doReplacement(String font) {
        String replacement = null;
        if (this.replaceTable.containsKey(font)) {
            replacement = this.replaceTable.get(font);
            if (this.fontProperties.get(replacement) != null) {
                System.out.println("Trovato sostituto font '" + font + "' -> '" + replacement + "'");
            } else {
                System.err.println("Il sostituto del font '" + font + "' -> '" + replacement + "' non \u00e8 presente");
            }
        }
        return replacement;
    }

    public synchronized void addReplacement(String from, String to) {
        this.replaceTable.put(from, to);
    }

    public synchronized void clearReplacements() {
        this.replaceTable.clear();
    }

    public String getFontDescriptionFromStyle(DXFStyle style) {
        if (StringUtils.isBlank((CharSequence)style.getBigFontFile()) || StringUtils.isBlank((CharSequence)style.getFontFile())) {
            return null;
        }
        String fontID = null;
        fontID = this.hasFontDescription(style.getBigFontFile());
        if (fontID != null) {
            return fontID;
        }
        fontID = this.hasFontDescription(style.getFontFile());
        if (fontID != null) {
            return fontID;
        }
        System.err.println("Font non trovato: big -> '" + style.getBigFontFile() + "' normal -> '" + style.getFontFile() + "'");
        return null;
    }
}

