/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg.tools;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.dxf.DXFHeader;
import org.kabeja.dxf.DXFLayer;
import org.kabeja.dxf.DXFVariable;
import org.kabeja.parser.Parser;
import org.kabeja.parser.ParserBuilder;
import org.kabeja.svg.SVGGenerator;
import org.kabeja.xml.SAXPrettyOutputter;

public class LayerSeparator {
    public static void main(String[] args) {
        LayerSeparator split = new LayerSeparator();
        if (args.length >= 2) {
            split.processFile(args[0], args[1]);
        } else {
            split.processFile(args[0], null);
        }
    }

    public void processFile(String source, String result) {
        if (result == null) {
            result = source.substring(0, source.toLowerCase().lastIndexOf(".dxf"));
        }
        Parser parser = ParserBuilder.createDefaultParser();
        try {
            parser.parse(new FileInputStream(source), "");
            DXFDocument doc = parser.getDocument();
            this.splitLayers(doc, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void splitLayers(DXFDocument doc, String basename) {
        Iterator i = doc.getDXFLayerIterator();
        ArrayList<DXFLayer> layers = new ArrayList<DXFLayer>();
        Bounds b = doc.getBounds();
        while (i.hasNext()) {
            DXFLayer l = (DXFLayer)i.next();
            layers.add(l);
            i.remove();
        }
        DXFHeader h = doc.getDXFHeader();
        DXFVariable v = new DXFVariable("$PLIMMIN");
        v.setValue("10", "" + b.getMinimumX());
        v.setValue("20", "" + b.getMinimumY());
        h.setVariable(v);
        v = new DXFVariable("$PLIMMAX");
        v.setValue("10", "" + b.getMaximumX());
        v.setValue("20", "" + b.getMaximumY());
        h.setVariable(v);
        System.out.println(layers.size() + " layers to separate.");
        i = layers.iterator();
        int count = 0;
        while (i.hasNext()) {
            DXFLayer l = (DXFLayer)i.next();
            doc.addDXFLayer(l);
            System.out.println("Generate:" + basename + ++count + ".svg");
            this.output(doc, basename + count + ".svg");
            doc.removeDXFLayer(l.getName());
        }
    }

    public void output(DXFDocument doc, String file) {
        try {
            SAXPrettyOutputter writer = new SAXPrettyOutputter(new FileOutputStream(file), "UTF-8");
            writer.setDTD("svg PUBLIC \"-//W3C//DTD SVG 1.0//EN\" \"http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd\"");
            SVGGenerator svgGenerator = new SVGGenerator();
            svgGenerator.generate(doc, writer, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

