/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg.generators;

import java.util.Iterator;
import java.util.Map;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFPolyline;
import org.kabeja.dxf.DXFSpline;
import org.kabeja.dxf.DXFVertex;
import org.kabeja.dxf.helpers.DXFSplineConverter;
import org.kabeja.math.MathUtils;
import org.kabeja.math.TransformContext;
import org.kabeja.svg.SVGContext;
import org.kabeja.svg.SVGGenerationException;
import org.kabeja.svg.SVGPathBoundaryGenerator;
import org.kabeja.svg.SVGSAXGenerator;
import org.kabeja.svg.SVGSAXGeneratorManager;
import org.kabeja.svg.SVGUtils;
import org.kabeja.svg.generators.AbstractSVGSAXGenerator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SVGSplineGenerator
extends AbstractSVGSAXGenerator
implements SVGPathBoundaryGenerator {
    public void toSAX(ContentHandler handler, Map svgContext, DXFEntity entity, TransformContext transformContext) throws SAXException {
        DXFSpline spline = (DXFSpline)entity;
        DXFPolyline pline = DXFSplineConverter.toDXFPolyline(spline);
        pline.setID(spline.getID());
        SVGSAXGeneratorManager manager = (SVGSAXGeneratorManager)svgContext.get(SVGContext.SVGSAXGENERATOR_MANAGER);
        try {
            SVGSAXGenerator gen = manager.getSVGGenerator("POLYLINE");
            gen.toSAX(handler, svgContext, pline, transformContext);
        }
        catch (SVGGenerationException e) {
            throw new SAXException(e);
        }
    }

    public String getSVGPath(DXFEntity entity) {
        DXFVertex last;
        DXFSpline spline = (DXFSpline)entity;
        DXFPolyline pline = DXFSplineConverter.toDXFPolyline(spline);
        StringBuilder d = new StringBuilder();
        Iterator i = pline.getVertexIterator();
        DXFVertex first = last = (DXFVertex)i.next();
        d.append("M ");
        d.append(last.getX());
        d.append(" ");
        d.append(last.getY());
        d.append(" ");
        while (i.hasNext()) {
            DXFVertex end = (DXFVertex)i.next();
            d.append(this.getVertexPath(last, end, pline));
            last = end;
        }
        if (pline.isClosed()) {
            if (last.getBulge() != 0.0) {
                d.append(this.getVertexPath(last, first, pline));
            }
            d.append(" z");
        }
        return d.toString();
    }

    protected String getVertexPath(DXFVertex start, DXFVertex end, DXFPolyline pline) {
        StringBuilder d = new StringBuilder();
        if (start.getBulge() != 0.0) {
            double l = MathUtils.distance(start.getPoint(), end.getPoint());
            if (l > 0.0) {
                double r = pline.getRadius(Math.abs(start.getBulge()), l);
                double h = start.getBulge() * l / 2.0;
                d.append("A ");
                d.append(SVGUtils.formatNumberAttribute(r));
                d.append(" ");
                d.append(SVGUtils.formatNumberAttribute(r));
                d.append(" 0");
                if (Math.abs(start.getBulge()) > 1.0) {
                    d.append(" 1 ");
                } else {
                    d.append(" 0 ");
                }
                if (start.getBulge() < 0.0) {
                    d.append(" 0 ");
                } else {
                    d.append(" 1 ");
                }
                d.append(end.getX());
                d.append(" ");
                d.append(end.getY());
                d.append(" ");
            }
        } else {
            d.append("L ");
            d.append(SVGUtils.formatNumberAttribute(end.getX()));
            d.append(" ");
            d.append(SVGUtils.formatNumberAttribute(end.getY()));
            d.append(" ");
        }
        return d.toString();
    }
}

