/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg.generators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFPolyline;
import org.kabeja.dxf.DXFVertex;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.dxf.helpers.PolylineSegment;
import org.kabeja.math.MathUtils;
import org.kabeja.math.TransformContext;
import org.kabeja.svg.SVGPathBoundaryGenerator;
import org.kabeja.svg.SVGUtils;
import org.kabeja.svg.generators.AbstractSVGSAXGenerator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SVGPolylineGenerator
extends AbstractSVGSAXGenerator
implements SVGPathBoundaryGenerator {
    public void toSAX(ContentHandler handler, Map svgContext, DXFEntity entity, TransformContext transformContext) throws SAXException {
        DXFPolyline pline = (DXFPolyline)entity;
        if (pline.getVertexCount() > 0) {
            if (pline.is3DPolygonMesh()) {
                this.meshToSAX(handler, svgContext, pline);
            } else if (pline.isPolyfaceMesh()) {
                this.polyfaceToSAX(handler, svgContext, pline);
            } else if (!pline.isCurveFitVerticesAdded()) {
                if (pline.isSplineFitVerticesAdded()) {
                    this.splineFitToSAX(handler, svgContext, pline);
                } else if (pline.is3DPolygon()) {
                    this.splineFitToSAX(handler, svgContext, pline);
                } else {
                    this.polylineToSAX(handler, svgContext, pline);
                }
            }
        }
    }

    protected void polylineToSAX(ContentHandler handler, Map svgContext, DXFPolyline pline) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        if (pline.getStartWidth() != pline.getEndWidth() || !pline.isConstantWidth()) {
            this.polylinePartToSAX(handler, svgContext, pline);
        } else {
            DXFVertex last;
            StringBuilder d = new StringBuilder();
            Iterator i = pline.getVertexIterator();
            DXFVertex first = last = (DXFVertex)i.next();
            d.append("M ");
            d.append(SVGUtils.formatNumberAttribute(last.getX()));
            d.append(" ");
            d.append(SVGUtils.formatNumberAttribute(last.getY()));
            d.append(" ");
            while (i.hasNext()) {
                DXFVertex end = (DXFVertex)i.next();
                d.append(this.getVertexPath(last, end, pline));
                last = end;
            }
            if (pline.isClosed()) {
                if (last.getBulge() != 0.0) {
                    d.append(this.getVertexPath(last, first, pline));
                }
                d.append(" z");
            }
            SVGUtils.addAttribute(attr, "d", d.toString());
            super.setCommonAttributes(attr, svgContext, pline);
            if (pline.getStartWidth() > 0.0) {
                SVGUtils.addAttribute(attr, "stroke-width", SVGUtils.formatNumberAttribute(pline.getStartWidth()));
            }
            SVGUtils.emptyElement(handler, "path", attr);
        }
    }

    public String getSVGPath(DXFEntity entity) {
        DXFVertex last;
        DXFPolyline pline = (DXFPolyline)entity;
        StringBuilder d = new StringBuilder();
        Iterator i = pline.getVertexIterator();
        DXFVertex first = last = (DXFVertex)i.next();
        d.append("M ");
        d.append(last.getX());
        d.append(" ");
        d.append(last.getY());
        d.append(" ");
        while (i.hasNext()) {
            DXFVertex end = (DXFVertex)i.next();
            d.append(this.getVertexPath(last, end, pline));
            last = end;
        }
        if (pline.isClosed()) {
            if (last.getBulge() != 0.0) {
                d.append(this.getVertexPath(last, first, pline));
            }
            d.append(" z");
        }
        return d.toString();
    }

    protected void polylinePartToSAX(ContentHandler handler, Map svgContext, DXFPolyline pline) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        super.setCommonAttributes(attr, svgContext, pline);
        SVGUtils.startElement(handler, "g", attr);
        String oldID = pline.getID();
        PolylineSegment segment = null;
        boolean process = true;
        DXFVertex start = pline.getVertex(0);
        DXFVertex end = pline.getVertex(1);
        segment = new PolylineSegment(start, end, pline);
        for (int i = 1; i < pline.getVertexCount(); ++i) {
            PolylineSegment next = null;
            if (i + 1 < pline.getVertexCount()) {
                process = false;
                DXFVertex nextStart = end;
                next = new PolylineSegment(nextStart, end = pline.getVertex(i + 1), pline);
                if (next.isBulged()) {
                    segment.setPoint3(next.getPoint2());
                    segment.setPoint4(next.getPoint1());
                } else {
                    segment.connect(next);
                }
            }
            StringBuilder d = new StringBuilder();
            d.append("M ");
            if (segment.isBulged()) {
                d.append(segment.getPoint1().getX());
                d.append(" ");
                d.append(segment.getPoint1().getY());
                d.append(" L ");
                d.append(segment.getPoint2().getX());
                d.append(" ");
                d.append(segment.getPoint2().getY());
                double r = 0.0;
                r = segment.getBulge() > 0.0 ? segment.getInnerRadius() : segment.getOuterRadius();
                d.append(" A ");
                d.append(SVGUtils.formatNumberAttribute(r));
                d.append(' ');
                d.append(SVGUtils.formatNumberAttribute(r));
                d.append(" 0 ");
                if (Math.abs(segment.getBulgeHeight()) > Math.abs(segment.getRadius())) {
                    d.append(" 1 ");
                } else {
                    d.append(" 0 ");
                }
                if (segment.getBulge() > 0.0) {
                    d.append(" 0 ");
                } else {
                    d.append(" 1 ");
                }
                d.append(segment.getPoint3().getX());
                d.append(" ");
                d.append(segment.getPoint3().getY());
                d.append(" L ");
                d.append(segment.getPoint4().getX());
                d.append(" ");
                d.append(segment.getPoint4().getY());
                r = 0.0;
                r = segment.getBulge() > 0.0 ? segment.getInnerRadius() : segment.getOuterRadius();
                d.append(" A ");
                d.append(SVGUtils.formatNumberAttribute(r));
                d.append(' ');
                d.append(SVGUtils.formatNumberAttribute(r));
                d.append(" 0 ");
                if (Math.abs(segment.getBulgeHeight()) > Math.abs(segment.getRadius())) {
                    d.append(" 1 ");
                } else {
                    d.append(" 0 ");
                }
                if (segment.getBulge() > 0.0) {
                    d.append(" 0 ");
                } else {
                    d.append(" 1 ");
                }
                d.append(segment.getPoint1().getX());
                d.append(" ");
                d.append(segment.getPoint1().getY());
                d.append(" Z");
            } else {
                d.append(segment.getPoint1().getX());
                d.append(" ");
                d.append(segment.getPoint1().getY());
                d.append(" L ");
                d.append(segment.getPoint2().getX());
                d.append(" ");
                d.append(segment.getPoint2().getY());
                d.append(" L ");
                d.append(segment.getPoint3().getX());
                d.append(" ");
                d.append(segment.getPoint3().getY());
                d.append(" L ");
                d.append(segment.getPoint4().getX());
                d.append(" ");
                d.append(segment.getPoint4().getY());
                d.append(" Z");
            }
            attr = new AttributesImpl();
            pline.setID(pline.getID() + "__" + i);
            super.setCommonAttributes(attr, svgContext, pline);
            if (pline.getDXFDocument().getDXFHeader().isFillMode()) {
                SVGUtils.addAttribute(attr, "fill", "currentColor");
            }
            SVGUtils.addAttribute(attr, "d", d.toString());
            SVGUtils.emptyElement(handler, "path", attr);
            if (process) continue;
            segment = next;
        }
        SVGUtils.endElement(handler, "g");
        pline.setID(oldID);
    }

    protected void splineFitToSAX(ContentHandler handler, Map svgContext, DXFPolyline pline) throws SAXException {
        StringBuilder d = new StringBuilder();
        Iterator i = pline.getVertexIterator();
        DXFVertex last = (DXFVertex)i.next();
        d.append("M " + last.getX() + " " + last.getY() + " ");
        while (i.hasNext()) {
            DXFVertex vertex = (DXFVertex)i.next();
            if (!vertex.is2DSplineApproximationVertex()) continue;
            d.append("L ");
            d.append(vertex.getX());
            d.append(" ");
            d.append(vertex.getY());
            d.append(" ");
        }
        AttributesImpl attr = new AttributesImpl();
        super.setCommonAttributes(attr, svgContext, pline);
        SVGUtils.addAttribute(attr, "d", d.toString());
        SVGUtils.emptyElement(handler, "path", attr);
    }

    protected void singleEdgeToSAX(ContentHandler handler, DXFVertex start, DXFVertex end, Map svgContext, DXFPolyline pline) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        super.setCommonAttributes(attr, svgContext, pline);
        StringBuilder d = new StringBuilder();
        d.append("M ");
        d.append(start.getX());
        d.append(" ");
        d.append(start.getY());
        d.append(" ");
        d.append(this.getVertexPath(start, end, pline));
        SVGUtils.addAttribute(attr, "d", d.toString());
        if (start.getStartWidth() > 0.0) {
            SVGUtils.addAttribute(attr, "stroke-width", start.getStartWidth());
        }
        SVGUtils.emptyElement(handler, "path", attr);
    }

    protected void polyfaceToSAX(ContentHandler handler, Map svgContext, DXFPolyline pline) throws SAXException {
        Iterator i = pline.getVertexIterator();
        StringBuilder buf = new StringBuilder();
        while (i.hasNext()) {
            DXFVertex v = (DXFVertex)i.next();
            if (!v.isFaceRecord()) continue;
            DXFVertex v1 = pline.getPolyFaceMeshVertex(v.getPolyFaceMeshVertex0());
            DXFVertex v2 = pline.getPolyFaceMeshVertex(v.getPolyFaceMeshVertex1());
            DXFVertex v3 = pline.getPolyFaceMeshVertex(v.getPolyFaceMeshVertex2());
            DXFVertex v4 = pline.getPolyFaceMeshVertex(v.getPolyFaceMeshVertex3());
            if (v.isPolyFaceEdge0Visible() && v.getPolyFaceMeshVertex0() != 0) {
                this.addEdgeToPath(v1, v2, buf);
            }
            if (v.isPolyFaceEdge1Visible() && v.getPolyFaceMeshVertex1() != 0) {
                this.addEdgeToPath(v2, v3, buf);
            }
            if (v.isPolyFaceEdge2Visible() && v.getPolyFaceMeshVertex2() != 0) {
                this.addEdgeToPath(v3, v4, buf);
            }
            if (v.isPolyFaceEdge3Visible() && v.getPolyFaceMeshVertex3() != 0) {
                this.addEdgeToPath(v4, v1, buf);
            } else if (v4 == null && v3 != null) {
                this.addEdgeToPath(v3, v1, buf);
            }
            if (buf.length() <= 0) continue;
            AttributesImpl attr = new AttributesImpl();
            SVGUtils.addAttribute(attr, "d", buf.toString());
            super.setCommonAttributes(attr, svgContext, v);
            SVGUtils.emptyElement(handler, "path", attr);
            buf.delete(0, buf.length());
        }
        if (buf.length() > 0) {
            AttributesImpl attr = new AttributesImpl();
            SVGUtils.addAttribute(attr, "d", buf.toString());
            super.setCommonAttributes(attr, svgContext, pline);
            SVGUtils.emptyElement(handler, "path", attr);
        }
    }

    protected void addEdgeToPath(DXFVertex start, DXFVertex end, StringBuilder buf) {
        buf.append('M');
        buf.append(" ");
        buf.append(start.getX());
        buf.append(" ");
        buf.append(start.getY());
        buf.append(" ");
        if (end != null) {
            buf.append('L');
            buf.append(" ");
            buf.append(end.getX());
            buf.append(" ");
            buf.append(end.getY());
            buf.append(" ");
        }
    }

    protected void meshToSAX(ContentHandler handler, Map svgContext, DXFPolyline pline) throws SAXException {
        StringBuilder d = new StringBuilder();
        if (pline.isSimpleMesh()) {
            int x;
            int i;
            int rows = pline.getRows();
            d = new StringBuilder();
            Point[][] points = new Point[pline.getRows()][pline.getColumns()];
            Iterator it = pline.getVertexIterator();
            for (i = 0; i < pline.getRows(); ++i) {
                d.append("M ");
                for (x = 0; x < pline.getColumns(); ++x) {
                    DXFVertex v = (DXFVertex)it.next();
                    points[i][x] = v.getPoint();
                    d.append(v.getX());
                    d.append(" ");
                    d.append(v.getY());
                    if (x >= pline.getColumns() - 1) continue;
                    d.append(" L ");
                }
                if (!pline.isClosedMeshNDirection()) continue;
                d.append('L');
                d.append(" ");
                d.append(points[i][0].getX());
                d.append(" ");
                d.append(points[i][0].getY());
                d.append(" ");
            }
            for (i = 0; i < pline.getColumns(); ++i) {
                d.append(" M ");
                for (x = 0; x < pline.getRows(); ++x) {
                    d.append(points[x][i].getX());
                    d.append(" ");
                    d.append(points[x][i].getY());
                    if (x >= pline.getRows() - 1) continue;
                    d.append(" L ");
                }
                if (!pline.isClosedMeshMDirection()) continue;
                d.append('L');
                d.append(" ");
                d.append(points[0][i].getX());
                d.append(" ");
                d.append(points[0][i].getY());
                d.append(" ");
            }
        } else {
            int x;
            int i;
            Point[][] points = new Point[pline.getSurefaceDensityRows()][pline.getSurefaceDensityColumns()];
            Iterator vi = pline.getVertexIterator();
            ArrayList<DXFVertex> appVertices = new ArrayList<DXFVertex>();
            while (vi.hasNext()) {
                DXFVertex v = (DXFVertex)vi.next();
                if (!v.isMeshApproximationVertex()) continue;
                appVertices.add(v);
            }
            Iterator it = appVertices.iterator();
            for (i = 0; i < pline.getSurefaceDensityRows(); ++i) {
                d.append("M ");
                for (x = 0; x < pline.getSurefaceDensityColumns(); ++x) {
                    DXFVertex v = (DXFVertex)it.next();
                    points[i][x] = v.getPoint();
                    d.append(v.getX());
                    d.append(" ");
                    d.append(v.getY());
                    if (x >= pline.getSurefaceDensityColumns() - 1) continue;
                    d.append(" L ");
                }
                if (!pline.isClosedMeshNDirection()) continue;
                d.append('L');
                d.append(" ");
                d.append(points[i][0].getX());
                d.append(" ");
                d.append(points[i][0].getY());
                d.append(" ");
            }
            for (i = 0; i < pline.getSurefaceDensityColumns(); ++i) {
                d.append(" M ");
                for (x = 0; x < pline.getSurefaceDensityRows(); ++x) {
                    d.append(points[x][i].getX());
                    d.append(" ");
                    d.append(points[x][i].getY());
                    if (x >= pline.getSurefaceDensityRows() - 1) continue;
                    d.append(" L ");
                }
                if (!pline.isClosedMeshMDirection()) continue;
                d.append('L');
                d.append(" ");
                d.append(points[0][i].getX());
                d.append(" ");
                d.append(points[0][i].getY());
                d.append(" ");
            }
        }
        AttributesImpl attr = new AttributesImpl();
        SVGUtils.addAttribute(attr, "d", d.toString());
        super.setCommonAttributes(attr, svgContext, pline);
        SVGUtils.emptyElement(handler, "path", attr);
    }

    protected String getVertexPath(DXFVertex start, DXFVertex end, DXFPolyline pline) {
        StringBuilder d = new StringBuilder();
        if (start.getBulge() != 0.0) {
            double l = MathUtils.distance(start.getPoint(), end.getPoint());
            if (l > 0.0) {
                double r = pline.getRadius(Math.abs(start.getBulge()), l);
                double h = start.getBulge() * l / 2.0;
                d.append("A ");
                d.append(SVGUtils.formatNumberAttribute(r));
                d.append(" ");
                d.append(SVGUtils.formatNumberAttribute(r));
                d.append(" 0");
                if (Math.abs(start.getBulge()) > 1.0) {
                    d.append(" 1 ");
                } else {
                    d.append(" 0 ");
                }
                if (start.getBulge() < 0.0) {
                    d.append(" 0 ");
                } else {
                    d.append(" 1 ");
                }
                d.append(end.getX());
                d.append(" ");
                d.append(end.getY());
                d.append(" ");
            }
        } else {
            d.append("L ");
            d.append(SVGUtils.formatNumberAttribute(end.getX()));
            d.append(" ");
            d.append(SVGUtils.formatNumberAttribute(end.getY()));
            d.append(" ");
        }
        return d.toString();
    }
}

