/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg.generators;

import java.util.Map;
import org.kabeja.dxf.DXFBlock;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFInsert;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.math.TransformContext;
import org.kabeja.svg.SVGContext;
import org.kabeja.svg.SVGUtils;
import org.kabeja.svg.generators.AbstractSVGSAXGenerator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SVGInsertGenerator
extends AbstractSVGSAXGenerator {
    public void toSAX(ContentHandler handler, Map svgContext, DXFEntity entity, TransformContext transformContext) throws SAXException {
        double scale_y;
        DXFInsert insert = (DXFInsert)entity;
        DXFBlock block = insert.getDXFDocument().getDXFBlock(insert.getBlockID());
        StringBuilder buf = new StringBuilder();
        Point referencePoint = block.getReferencePoint();
        int rows = insert.getRows();
        int columns = insert.getColumns();
        double rotate = insert.getRotate();
        Point insertPoint = insert.getPoint();
        double scale_x = insert.getScaleX();
        if (scale_x < 0.0) {
            scale_x *= -1.0;
        }
        if ((scale_y = insert.getScaleY()) < 0.0) {
            scale_y *= -1.0;
        }
        double column_spacing = insert.getColumnSpacing();
        double row_spacing = insert.getRowSpacing();
        for (int column = 0; column < columns; ++column) {
            for (int row = 0; row < rows; ++row) {
                buf.append("translate(");
                buf.append(SVGUtils.formatNumberAttribute(insertPoint.getX() - column_spacing * (double)column));
                buf.append(" ");
                buf.append(SVGUtils.formatNumberAttribute(insertPoint.getY() - row_spacing * (double)row));
                buf.append(")");
                if (rotate != 0.0) {
                    buf.append(" rotate(");
                    buf.append(SVGUtils.formatNumberAttribute(rotate));
                    buf.append(")");
                }
                if (scale_x != 1.0 || scale_y != 1.0) {
                    buf.append(" scale(");
                    buf.append(SVGUtils.formatNumberAttribute(scale_x));
                    buf.append(" ");
                    buf.append(SVGUtils.formatNumberAttribute(scale_y));
                    buf.append(")");
                }
                if (referencePoint.getX() != 0.0 || referencePoint.getY() != 0.0) {
                    buf.append(" translate(");
                    buf.append(SVGUtils.formatNumberAttribute(-1.0 * referencePoint.getX()));
                    buf.append(" ");
                    buf.append(SVGUtils.formatNumberAttribute(-1.0 * referencePoint.getY()));
                    buf.append(")");
                }
                AttributesImpl attr = new AttributesImpl();
                SVGUtils.addAttribute(attr, "transform", buf.toString());
                super.setCommonAttributes(attr, svgContext, insert);
                if (Math.abs(scale_x) + Math.abs(scale_y) != 0.0 && svgContext.containsKey(SVGContext.LAYER_STROKE_WIDTH)) {
                    Double lw = (Double)svgContext.get(SVGContext.LAYER_STROKE_WIDTH);
                    double width = lw * 2.0 / (Math.abs(scale_x) + Math.abs(scale_y));
                    String value = SVGUtils.formatNumberAttribute(width);
                    int index = attr.getIndex("stroke-width");
                    if (index == -1) {
                        SVGUtils.addAttribute(attr, "stroke-width", value);
                    } else {
                        attr.setValue(index, value);
                    }
                }
                attr.addAttribute("http://www.w3.org/2000/xmlns/", "xlink", "xmlns:xlink", SVGUtils.DEFAUL_ATTRIBUTE_TYPE, "http://www.w3.org/1999/xlink");
                attr.addAttribute("http://www.w3.org/1999/xlink", "href", "xlink:href", SVGUtils.DEFAUL_ATTRIBUTE_TYPE, "#" + SVGUtils.validateID(insert.getBlockID()));
                SVGUtils.emptyElement(handler, "use", attr);
                buf.delete(0, buf.length());
            }
        }
    }
}

