/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg.generators;

import java.util.Map;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFImage;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.dxf.objects.DXFImageDefObject;
import org.kabeja.math.TransformContext;
import org.kabeja.svg.SVGUtils;
import org.kabeja.svg.generators.AbstractSVGSAXGenerator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SVGImageGenerator
extends AbstractSVGSAXGenerator {
    public void toSAX(ContentHandler handler, Map svgContext, DXFEntity entity, TransformContext transformContext) throws SAXException {
        DXFImage image = (DXFImage)entity;
        DXFImageDefObject imageDef = (DXFImageDefObject)image.getDXFDocument().getDXFObjectByID(image.getImageDefObjectID());
        if (imageDef != null) {
            AttributesImpl attr = new AttributesImpl();
            super.setCommonAttributes(attr, svgContext, image);
            Point insertPoint = image.getInsertPoint();
            double imageSizeAlongU = image.getImageSizeAlongU();
            double imageSizeAlongV = image.getImageSizeAlongV();
            SVGUtils.addAttribute(attr, "x", SVGUtils.formatNumberAttribute(insertPoint.getX()));
            SVGUtils.addAttribute(attr, "y", SVGUtils.formatNumberAttribute(insertPoint.getY()));
            SVGUtils.addAttribute(attr, "width", SVGUtils.formatNumberAttribute(imageSizeAlongU));
            SVGUtils.addAttribute(attr, "height", SVGUtils.formatNumberAttribute(imageSizeAlongV));
            attr.addAttribute("http://www.w3.org/2000/xmlns/", "xlink", "xmlns:xlink", SVGUtils.DEFAUL_ATTRIBUTE_TYPE, "http://www.w3.org/1999/xlink");
            attr.addAttribute("http://www.w3.org/1999/xlink", "href", "xlink:href", SVGUtils.DEFAUL_ATTRIBUTE_TYPE, SVGUtils.pathToURI(imageDef.getFilename()));
            StringBuilder transform = new StringBuilder();
            transform.append("rotate(180 ");
            transform.append(SVGUtils.formatNumberAttribute(insertPoint.getX() + imageSizeAlongU / 2.0));
            transform.append(" ");
            transform.append(SVGUtils.formatNumberAttribute(insertPoint.getY() + imageSizeAlongV / 2.0));
            transform.append(")");
            SVGUtils.addAttribute(attr, "transform", transform.toString());
            SVGUtils.emptyElement(handler, "image", attr);
        }
    }
}

