/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg.generators;

import java.util.Map;
import org.kabeja.dxf.DXFBlock;
import org.kabeja.dxf.DXFDimension;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.math.TransformContext;
import org.kabeja.svg.SVGContext;
import org.kabeja.svg.SVGUtils;
import org.kabeja.svg.generators.AbstractSVGSAXGenerator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SVGDimensionGenerator
extends AbstractSVGSAXGenerator {
    public void toSAX(ContentHandler handler, Map svgContext, DXFEntity entity, TransformContext transformContext) throws SAXException {
        DXFDimension dimension = (DXFDimension)entity;
        if (dimension.getDXFDocument().getDXFBlock(dimension.getDimensionBlock()) != null) {
            DXFBlock block = dimension.getDXFDocument().getDXFBlock(dimension.getDimensionBlock());
            AttributesImpl attr = new AttributesImpl();
            StringBuilder buf = new StringBuilder();
            buf.append("translate(");
            buf.append(dimension.getInsertPoint().getX());
            buf.append(" ");
            buf.append(dimension.getInsertPoint().getY());
            buf.append(")");
            Point referencePoint = block.getReferencePoint();
            if (referencePoint.getX() != 0.0 || referencePoint.getY() != 0.0) {
                buf.append(" translate(");
                buf.append(SVGUtils.formatNumberAttribute(referencePoint.getX()));
                buf.append(" ");
                buf.append(SVGUtils.formatNumberAttribute(referencePoint.getY()));
                buf.append(")");
            }
            SVGUtils.addAttribute(attr, "transform", buf.toString());
            super.setCommonAttributes(attr, svgContext, dimension);
            if (svgContext.containsKey(SVGContext.LAYER_STROKE_WIDTH)) {
                Double lw = (Double)svgContext.get(SVGContext.LAYER_STROKE_WIDTH);
                String value = SVGUtils.formatNumberAttribute(lw);
                int index = attr.getIndex("stroke-width");
                if (index == -1) {
                    SVGUtils.addAttribute(attr, "stroke-width", value);
                } else {
                    attr.setValue(index, value);
                }
            }
            SVGUtils.startElement(handler, "g", attr);
            attr = new AttributesImpl();
            attr.addAttribute("http://www.w3.org/2000/xmlns/", "xlink", "xmlns:xlink", SVGUtils.DEFAUL_ATTRIBUTE_TYPE, "http://www.w3.org/1999/xlink");
            attr.addAttribute("http://www.w3.org/1999/xlink", "href", "xlink:href", SVGUtils.DEFAUL_ATTRIBUTE_TYPE, "#" + SVGUtils.validateID(dimension.getDimensionBlock()));
            SVGUtils.emptyElement(handler, "use", attr);
            SVGUtils.endElement(handler, "g");
        }
    }
}

