/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg.generators;

import java.util.Map;
import org.kabeja.dxf.DXFArc;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.math.TransformContext;
import org.kabeja.svg.SVGPathBoundaryGenerator;
import org.kabeja.svg.SVGUtils;
import org.kabeja.svg.generators.AbstractSVGSAXGenerator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SVGArcGenerator
extends AbstractSVGSAXGenerator
implements SVGPathBoundaryGenerator {
    public void toSAX(ContentHandler handler, Map svgContext, DXFEntity entity, TransformContext transformContext) throws SAXException {
        DXFArc arc = (DXFArc)entity;
        AttributesImpl attr = new AttributesImpl();
        SVGUtils.addAttribute(attr, "d", this.getSVGPath(arc));
        super.setCommonAttributes(attr, svgContext, arc);
        SVGUtils.emptyElement(handler, "path", attr);
    }

    public String getSVGPath(DXFEntity entity) {
        DXFArc arc = (DXFArc)entity;
        StringBuilder path = new StringBuilder();
        Point p = arc.getStartPoint();
        double radius = arc.getRadius();
        path.append("M ");
        path.append(p.getX());
        path.append(' ');
        path.append(p.getY());
        path.append(" A ");
        path.append(radius);
        path.append(' ');
        path.append(radius);
        path.append(" 0");
        double diff = arc.getTotalAngle();
        if (diff > 180.0) {
            path.append(" 1 ");
        } else {
            path.append(" 0 ");
        }
        if (!arc.isCounterClockwise() && arc.getExtrusion().getZ() > 0.0) {
            path.append(" 1 ");
        } else {
            path.append(" 0 ");
        }
        double angle = arc.getEndAngle();
        if (arc.isCounterClockwise()) {
            angle = -1.0 * angle;
        }
        p = arc.getPointAt(angle);
        path.append(' ');
        path.append(p.getX());
        path.append(' ');
        path.append(p.getY());
        return path.toString();
    }
}

