/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg.dimension;

import java.util.Map;
import org.kabeja.dxf.DXFDimension;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.math.TransformContext;
import org.kabeja.svg.SVGUtils;
import org.kabeja.svg.dimension.AbstractDimensionOutputter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class LinearDimensionOutputter
extends AbstractDimensionOutputter {
    public LinearDimensionOutputter(DXFDimension dim) {
        super(dim);
    }

    public void output(ContentHandler handler, Map svgContext) throws SAXException {
        if (this.dim.getDimensionBlock().length() > 0) {
            AttributesImpl attr = new AttributesImpl();
            StringBuilder buf = new StringBuilder();
            buf.append("translate(");
            buf.append(this.dim.getInsertPoint().getX());
            buf.append(" ");
            buf.append(this.dim.getInsertPoint().getY());
            buf.append(")");
            SVGUtils.addAttribute(attr, "transform", buf.toString());
            this.setCommonAttributes(attr, svgContext, this.dim);
            SVGUtils.startElement(handler, "g", attr);
            attr = new AttributesImpl();
            attr.addAttribute("http://www.w3.org/2000/xmlns/", "xlink", "xmlns:xlink", SVGUtils.DEFAUL_ATTRIBUTE_TYPE, "http://www.w3.org/1999/xlink");
            attr.addAttribute("http://www.w3.org/1999/xlink", "href", "xlink:href", SVGUtils.DEFAUL_ATTRIBUTE_TYPE, "#" + SVGUtils.validateID(this.dim.getDimensionBlock()));
            SVGUtils.emptyElement(handler, "use", attr);
            SVGUtils.endElement(handler, "g");
        }
    }

    public void toSAX(ContentHandler handler, Map svgContext, DXFEntity entity, TransformContext transformContext) throws SAXException {
        this.output(handler, svgContext);
    }
}

