/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg.dimension;

import org.kabeja.dxf.DXFDimension;
import org.kabeja.dxf.DXFDimensionStyle;
import org.kabeja.dxf.DXFVariable;
import org.kabeja.svg.SVGUtils;
import org.kabeja.svg.generators.AbstractSVGSAXGenerator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractDimensionOutputter
extends AbstractSVGSAXGenerator {
    protected DXFDimension dim;

    public AbstractDimensionOutputter(DXFDimension dim) {
        this.dim = dim;
    }

    protected void outputText(ContentHandler handler) throws SAXException {
        if (this.dim.getDimensionText().length() > 0 && this.dim.getDimensionText().indexOf("<>") < 0) {
            System.out.println("Textdim:" + this.dim.getDimensionText());
            AttributesImpl attr = new AttributesImpl();
            SVGUtils.addAttribute(attr, "x", this.dim.getTextPoint().getX());
            SVGUtils.addAttribute(attr, "y", this.dim.getTextPoint().getY());
            StringBuilder transform = new StringBuilder();
            transform.append("matrix(1 0 0 -1 0 ");
            transform.append(2.0 * this.dim.getTextPoint().getY());
            transform.append(")");
            if (this.dim.getTextRotation() != 0.0) {
                double rotation = 0.0;
                if (this.dim.getDimensionRotation() != 0.0) {
                    rotation = 360.0 - this.dim.getDimensionRotation();
                }
                transform.append(" rotate(");
                transform.append(-1.0 * (rotation += this.dim.getTextRotation()));
                transform.append(" ");
                transform.append(this.dim.getTextPoint().getX());
                transform.append(" ");
                transform.append(this.dim.getTextPoint().getY());
                transform.append(" )");
            }
            SVGUtils.addAttribute(attr, "transform", transform.toString());
            DXFDimensionStyle style = this.dim.getDXFDimensionStyle();
            if (style == null) {
                style = this.dim.getDXFDocument().getDXFDimensionStyle("STANDARD");
            }
            if (style != null && style.hasProperty("140")) {
                double height = style.getDoubleProperty("140");
                System.out.println("height from style:" + height);
                SVGUtils.addAttribute(attr, "font-size", height);
            } else {
                DXFVariable var = this.dim.getDXFDocument().getDXFHeader().getVariable("$DIMTXT");
                if (var != null && var.getDoubleValue("40") != 0.0) {
                    System.out.println("height from doc:" + var.getDoubleValue("40"));
                    SVGUtils.addAttribute(attr, "font-size", var.getDoubleValue("40"));
                }
            }
            SVGUtils.addAttribute(attr, "writing-mode", "rl");
            SVGUtils.addAttribute(attr, "text-anchor", "middle");
            SVGUtils.addAttribute(attr, "alignment-baseline", "middle");
            SVGUtils.addAttribute(attr, "fill", "currentColor");
            SVGUtils.startElement(handler, "text", attr);
            SVGUtils.characters(handler, this.dim.getDimensionText());
            SVGUtils.endElement(handler, "text");
        }
    }
}

