/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFBlock;
import org.kabeja.dxf.DXFColor;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFLayer;
import org.kabeja.dxf.DXFLineType;
import org.kabeja.dxf.DXFStyle;
import org.kabeja.dxf.DXFVariable;
import org.kabeja.dxf.objects.DXFDictionary;
import org.kabeja.dxf.objects.DXFLayout;
import org.kabeja.math.TransformContext;
import org.kabeja.svg.SVGContext;
import org.kabeja.svg.SVGGenerationException;
import org.kabeja.svg.SVGSAXGenerator;
import org.kabeja.svg.SVGSAXGeneratorManager;
import org.kabeja.svg.SVGUtils;
import org.kabeja.svg.generators.SVGStyleGenerator;
import org.kabeja.xml.AbstractSAXGenerator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SVGGenerator
extends AbstractSAXGenerator {
    public static final String PROPERTY_MARGIN = "margin";
    public static final String PROPERTY_STROKE_WIDTH = "stroke-width";
    public static final String PROPERTY_DOCUMENT_BOUNDS = "useBounds";
    public static final String PROPERTY_DOCUMENT_BOUNDS_RULE = "bounds-rule";
    public static final int PROPERTY_DOCUMENT_BOUNDS_RULE_KABEJA = 1;
    public static final int PROPERTY_DOCUMENT_BOUNDS_RULE_PAPERSPACE = 2;
    public static final int PROPERTY_DOCUMENT_BOUNDS_RULE_MODELSPACE = 3;
    public static final String PROPERTY_DOCUMENT_BOUNDS_RULE_KABEJA_VALUE = "kabeja";
    public static final String PROPERTY_DOCUMENT_BOUNDS_RULE_PAPERSPACE_VALUE = "Paperspace";
    public static final String PROPERTY_DOCUMENT_BOUNDS_RULE_PAPERSPACE_LIMITS_VALUE = "Paperspace-Limits";
    public static final String PROPERTY_DOCUMENT_BOUNDS_RULE_MODELSPACE_VALUE = "Modelspace";
    public static final String PROPERTY_DOCUMENT_BOUNDS_RULE_MODELSPACE_LIMITS_VALUE = "Modelspace-Limits";
    public static final String PROPERTY_DOCUMENT_OUTPUT_STYLE = "output-style";
    public static final int PROPERTY_DOCUMENT_OUTPUT_STYLE_NOLAYOUT = 0;
    public static final int PROPERTY_DOCUMENT_OUTPUT_STYLE_LAYOUT = 1;
    public static final int PROPERTY_DOCUMENT_OUTPUT_STYLE_PLOTSETTING = 2;
    public static final String PROPERTY_DOCUMENT_OUTPUT_STYLE_LAYOUT_VALUE = "layout";
    public static final String PROPERTY_DOCUMENT_OUTPUT_STYLE_PLOTSETTING_VALUE = "plotsetting";
    public static final String PROPERTY_DOCUMENT_OUTPUT_STYLE_NAME = "output-style-name";
    public static final String PROPERTY_WIDTH = "width";
    public static final String PROPERTY_HEIGHT = "height";
    public static final String PROPERTY_OVERFLOW = "svg-overflow";
    public static final double DEFAULT_MARGIN_PERCENT = 0.0;
    public static final String SUPPORTED_SVG_VERSION = "1.1";
    private boolean overflow = true;
    private boolean useLimits = false;
    private int boundsRule = 3;
    private int outputStyle = 0;
    private String marginSettings;
    private String outputStyleName = "Model";
    protected SVGSAXGeneratorManager manager;

    protected void generate() throws SAXException {
        this.setupProperties();
        this.generateSAX();
        this.context = null;
    }

    protected void setupProperties() {
        String value;
        if (this.context == null) {
            this.context = new HashMap();
        } else {
            for (String key : this.context.keySet()) {
                this.properties.put(key, this.context.get(key));
            }
        }
        if (this.properties.containsKey(PROPERTY_MARGIN)) {
            this.marginSettings = (String)this.properties.get(PROPERTY_MARGIN);
        }
        if (this.properties.containsKey(PROPERTY_OVERFLOW)) {
            this.overflow = Boolean.valueOf((String)this.properties.get(PROPERTY_OVERFLOW));
        }
        if (this.properties.containsKey(PROPERTY_STROKE_WIDTH)) {
            this.context.put(SVGContext.STROKE_WIDTH, new Double(this.properties.get(PROPERTY_STROKE_WIDTH).toString()));
            this.context.put(SVGContext.STROKE_WIDTH_IGNORE, "");
        }
        if (this.properties.containsKey(PROPERTY_DOCUMENT_BOUNDS_RULE)) {
            value = ((String)this.properties.get(PROPERTY_DOCUMENT_BOUNDS_RULE)).trim();
            if (value.equals(PROPERTY_DOCUMENT_BOUNDS_RULE_KABEJA_VALUE)) {
                this.boundsRule = 3;
                this.useLimits = false;
            } else if (value.equals(PROPERTY_DOCUMENT_BOUNDS_RULE_PAPERSPACE_VALUE)) {
                this.boundsRule = 2;
                this.useLimits = false;
            } else if (value.equals(PROPERTY_DOCUMENT_BOUNDS_RULE_MODELSPACE_VALUE)) {
                this.boundsRule = 3;
                this.useLimits = false;
            } else if (value.equals(PROPERTY_DOCUMENT_BOUNDS_RULE_MODELSPACE_LIMITS_VALUE)) {
                this.boundsRule = 3;
                this.useLimits = true;
            } else if (value.equals(PROPERTY_DOCUMENT_BOUNDS_RULE_PAPERSPACE_LIMITS_VALUE)) {
                this.boundsRule = 2;
                this.useLimits = true;
            }
        }
        if (this.properties.containsKey(PROPERTY_DOCUMENT_OUTPUT_STYLE)) {
            value = ((String)this.properties.get(PROPERTY_DOCUMENT_OUTPUT_STYLE)).trim().toLowerCase();
            if (value.equals(PROPERTY_DOCUMENT_OUTPUT_STYLE_LAYOUT_VALUE)) {
                this.outputStyle = 1;
            } else if (value.equals(PROPERTY_DOCUMENT_OUTPUT_STYLE_PLOTSETTING_VALUE)) {
                this.outputStyle = 2;
            }
            if (this.properties.containsKey(PROPERTY_DOCUMENT_OUTPUT_STYLE_NAME)) {
                this.outputStyleName = ((String)this.properties.get(PROPERTY_DOCUMENT_OUTPUT_STYLE_NAME)).trim();
            }
        }
        if (this.manager == null) {
            this.manager = new SVGSAXGeneratorManager();
        }
        this.context.put(SVGContext.SVGSAXGENERATOR_MANAGER, this.manager);
    }

    private void generateSAX() throws SAXException {
        try {
            DXFLayout layout;
            DXFDictionary dict;
            this.handler.startDocument();
            AttributesImpl attr = new AttributesImpl();
            String viewport = "";
            Bounds bounds = this.getBounds();
            if (this.outputStyle == 0) {
                if (this.properties.containsKey(PROPERTY_WIDTH)) {
                    SVGUtils.addAttribute(attr, PROPERTY_WIDTH, (String)this.properties.get(PROPERTY_WIDTH));
                }
                if (this.properties.containsKey(PROPERTY_HEIGHT)) {
                    SVGUtils.addAttribute(attr, PROPERTY_HEIGHT, (String)this.properties.get(PROPERTY_HEIGHT));
                }
            } else if (this.outputStyle == 1 && (dict = (DXFDictionary)this.doc.getRootDXFDictionary().getDXFObjectByName("ACAD_LAYOUT")) != null && (layout = (DXFLayout)dict.getDXFObjectByName(this.outputStyleName)) != null) {
                Bounds b;
                Bounds paper = layout.getLimits();
                String units = "";
                switch (layout.getPaperUnit()) {
                    case 0: {
                        units = "in";
                        break;
                    }
                    case 1: {
                        units = "mm";
                        break;
                    }
                    case 2: {
                        units = "px";
                    }
                }
                if (paper.isValid() && paper.getWidth() > 0.0 && paper.getHeight() > 0.0) {
                    SVGUtils.addAttribute(attr, PROPERTY_HEIGHT, paper.getHeight() + units);
                    SVGUtils.addAttribute(attr, PROPERTY_WIDTH, paper.getWidth() + units);
                }
                if ((b = layout.getExtent()).isValid() && b.getWidth() > 0.0 && b.getHeight() > 0.0) {
                    bounds = b;
                }
            }
            viewport = SVGUtils.formatNumberAttribute(bounds.getMinimumX()) + " " + SVGUtils.formatNumberAttribute(-1.0 * bounds.getMaximumY()) + "  " + SVGUtils.formatNumberAttribute(bounds.getWidth()) + " " + SVGUtils.formatNumberAttribute(bounds.getHeight());
            SVGUtils.setStrokenWidthRatio((bounds.getMaximumX() + bounds.getMaximumY()) / 1000.0);
            SVGUtils.addAttribute(attr, "viewBox", viewport);
            SVGUtils.addAttribute(attr, "xmlns", "http://www.w3.org/2000/svg");
            SVGUtils.addAttribute(attr, "version", SUPPORTED_SVG_VERSION);
            if (this.overflow) {
                SVGUtils.addAttribute(attr, "overflow", "visible");
            }
            SVGUtils.startElement(this.handler, "svg", attr);
            attr = new AttributesImpl();
            SVGUtils.startElement(this.handler, "defs", attr);
            this.context.put(SVGContext.DRAFT_BOUNDS, bounds);
            double dotLength = 0.0;
            dotLength = bounds.getWidth() > bounds.getHeight() ? bounds.getHeight() * 2.5E-4 : bounds.getWidth() * 2.5E-4;
            this.context.put(SVGContext.DOT_LENGTH, new Double(dotLength));
            Iterator i = this.doc.getDXFBlockIterator();
            while (i.hasNext()) {
                DXFBlock block = (DXFBlock)i.next();
                this.blockToSAX(block, null);
            }
            i = this.doc.getDXFStyleIterator();
            while (i.hasNext()) {
                DXFStyle style = (DXFStyle)i.next();
                SVGStyleGenerator.toSAX(this.handler, this.context, style);
            }
            SVGUtils.endElement(this.handler, "defs");
            attr = new AttributesImpl();
            SVGUtils.addAttribute(attr, "id", "draft");
            SVGUtils.addAttribute(attr, "transform", "matrix(1 0 0 -1 0 0)");
            if (this.context.containsKey(SVGContext.STROKE_WIDTH)) {
                SVGUtils.addAttribute(attr, PROPERTY_STROKE_WIDTH, this.context.get(SVGContext.STROKE_WIDTH).toString());
            } else {
                double defaultSW;
                double sw = (bounds.getWidth() + bounds.getHeight()) / 2.0 * 2.5E-4;
                if (sw > (defaultSW = 0.25 * SVGUtils.getStrokenWidthRatio())) {
                    sw = defaultSW;
                }
                SVGUtils.addAttribute(attr, PROPERTY_STROKE_WIDTH, SVGUtils.formatNumberAttribute(sw));
                this.context.put(SVGContext.STROKE_WIDTH, new Double(sw));
            }
            SVGUtils.startElement(this.handler, "g", attr);
            i = this.doc.getDXFLayerIterator();
            while (i.hasNext()) {
                DXFLayer layer = (DXFLayer)i.next();
                if (this.boundsRule == 2) {
                    this.layerToSAX(layer, false);
                    continue;
                }
                this.layerToSAX(layer, true);
            }
            SVGUtils.endElement(this.handler, "g");
            SVGUtils.endElement(this.handler, "svg");
            this.handler.endDocument();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    protected void blockToSAX(DXFBlock block, TransformContext transformContext) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        SVGUtils.addAttribute(attr, "id", SVGUtils.validateID(block.getName()));
        SVGUtils.startElement(this.handler, "g", attr);
        Iterator i = block.getDXFEntitiesIterator();
        while (i.hasNext()) {
            DXFEntity entity = (DXFEntity)i.next();
            try {
                SVGSAXGenerator gen = this.manager.getSVGGenerator(entity.getType());
                gen.toSAX(this.handler, this.context, entity, transformContext);
            }
            catch (SVGGenerationException e) {
                e.printStackTrace();
            }
        }
        SVGUtils.endElement(this.handler, "g");
    }

    protected double[] getMargin(Bounds bounds) {
        double[] margin = new double[4];
        if (this.marginSettings != null) {
            StringTokenizer st = new StringTokenizer(this.marginSettings);
            int count = st.countTokens();
            switch (count) {
                case 4: {
                    for (int i = 0; i < count; ++i) {
                        String m = st.nextToken().trim();
                        if (m.endsWith("%")) {
                            m = m.substring(0, m.length() - 1);
                            if (i == 0 && i == 2) {
                                margin[i] = Double.parseDouble(m) / 100.0 * bounds.getHeight();
                                continue;
                            }
                            margin[i] = Double.parseDouble(m) / 100.0 * bounds.getWidth();
                            continue;
                        }
                        margin[i] = Double.parseDouble(m);
                    }
                    return margin;
                }
                case 1: {
                    String m = st.nextToken().trim();
                    if (m.endsWith("%")) {
                        m = m.substring(0, m.length() - 1);
                    }
                    margin[0] = Double.parseDouble(m);
                    margin[2] = margin[3] = margin[0];
                    margin[1] = margin[3];
                    return margin;
                }
            }
        }
        margin[0] = bounds.getHeight() * 0.0;
        margin[2] = margin[0];
        margin[1] = bounds.getWidth() * 0.0;
        margin[3] = margin[1];
        return margin;
    }

    protected Bounds getBounds() {
        DXFVariable min;
        Bounds bounds = null;
        if (this.boundsRule == 2) {
            DXFVariable max;
            bounds = new Bounds();
            if (this.doc.getDXFHeader().hasVariable("$PEXTMAX") && this.doc.getDXFHeader().hasVariable("$PEXTMIN") && this.useLimits) {
                min = this.doc.getDXFHeader().getVariable("$PEXTMIN");
                max = this.doc.getDXFHeader().getVariable("$PEXTMAX");
                bounds.setMinimumX(min.getDoubleValue("10"));
                bounds.setMinimumY(min.getDoubleValue("20"));
                bounds.setMaximumX(max.getDoubleValue("10"));
                bounds.setMaximumY(max.getDoubleValue("20"));
            }
            if ((!bounds.isValid() || bounds.getWidth() == 0.0 || bounds.getHeight() == 0.0) && this.doc.getDXFHeader().hasVariable("$PLIMMIN") && this.doc.getDXFHeader().hasVariable("$PLIMMAX") && this.useLimits) {
                min = this.doc.getDXFHeader().getVariable("$PLIMMIN");
                max = this.doc.getDXFHeader().getVariable("$PLIMMAX");
                bounds.setMinimumX(min.getDoubleValue("10"));
                bounds.setMinimumY(min.getDoubleValue("20"));
                bounds.setMaximumX(max.getDoubleValue("10"));
                bounds.setMaximumY(max.getDoubleValue("20"));
            }
            if (!bounds.isValid() || bounds.getWidth() == 0.0 || bounds.getHeight() == 0.0) {
                bounds = this.doc.getBounds(false);
            }
        } else if (this.boundsRule == 3) {
            DXFVariable max;
            bounds = new Bounds();
            if (this.doc.getDXFHeader().hasVariable("$EXTMIN") && this.doc.getDXFHeader().hasVariable("$EXTMAX") && this.useLimits) {
                min = this.doc.getDXFHeader().getVariable("$EXTMIN");
                max = this.doc.getDXFHeader().getVariable("$EXTMAX");
                bounds.setMinimumX(min.getDoubleValue("10"));
                bounds.setMinimumY(min.getDoubleValue("20"));
                bounds.setMaximumX(max.getDoubleValue("10"));
                bounds.setMaximumY(max.getDoubleValue("20"));
            }
            if ((!bounds.isValid() || bounds.getWidth() == 0.0 || bounds.getHeight() == 0.0) && this.doc.getDXFHeader().hasVariable("$LIMMIN") && this.doc.getDXFHeader().hasVariable("$LIMMAX") && this.useLimits) {
                min = this.doc.getDXFHeader().getVariable("$LIMMIN");
                max = this.doc.getDXFHeader().getVariable("$LIMMAX");
                bounds.setMinimumX(min.getDoubleValue("10"));
                bounds.setMinimumY(min.getDoubleValue("20"));
                bounds.setMaximumX(max.getDoubleValue("10"));
                bounds.setMaximumY(max.getDoubleValue("20"));
            }
            if (!bounds.isValid() || bounds.getWidth() == 0.0 || bounds.getHeight() == 0.0) {
                bounds = this.doc.getBounds(true);
            }
        }
        if (bounds == null || !bounds.isValid() || bounds.getWidth() == 0.0 || bounds.getHeight() == 0.0) {
            if (this.boundsRule == 2) {
                bounds = this.doc.getBounds(true);
                this.boundsRule = 3;
            } else {
                bounds = this.doc.getBounds(false);
                this.boundsRule = 2;
            }
        }
        double[] margin = this.getMargin(bounds);
        bounds.setMinimumX(bounds.getMinimumX() - margin[3]);
        bounds.setMaximumX(bounds.getMaximumX() + margin[1]);
        bounds.setMinimumY(bounds.getMinimumY() - margin[2]);
        bounds.setMaximumY(bounds.getMaximumY() + margin[0]);
        return bounds;
    }

    public void setSVGSAXGeneratorManager(SVGSAXGeneratorManager manager) {
        this.manager = manager;
    }

    protected void layerToSAX(DXFLayer layer, boolean onModelspace) throws SAXException {
        String lt;
        AttributesImpl attr = new AttributesImpl();
        SVGUtils.addAttribute(attr, "id", SVGUtils.validateID(layer.getName()));
        SVGUtils.addAttribute(attr, "color", "rgb(" + DXFColor.getRGBString(Math.abs(layer.getColor())) + ")");
        SVGUtils.addAttribute(attr, "stroke", "currentColor");
        SVGUtils.addAttribute(attr, "fill", "none");
        if (!layer.isVisible() && onModelspace) {
            SVGUtils.addAttribute(attr, "visibility", "hidden");
        }
        if ((lt = layer.getLineType()).length() > 0) {
            DXFLineType ltype = this.doc.getDXFLineType(lt);
            SVGUtils.addStrokeDashArrayAttribute(attr, ltype);
        }
        int lineWeight = layer.getLineWeight();
        Double lw = null;
        if (lineWeight > 0 && !this.context.containsKey(SVGContext.STROKE_WIDTH_IGNORE)) {
            lw = new Double(lineWeight);
            SVGUtils.addAttribute(attr, PROPERTY_STROKE_WIDTH, SVGUtils.lineWeightToStrokeWidth(lineWeight));
        } else {
            lw = (Double)this.context.get(SVGContext.STROKE_WIDTH);
            if (Double.isNaN(lw) || Double.isInfinite(lw)) {
                lw = SVGUtils.getStrokenWidthRatio() * 0.25;
            }
            SVGUtils.addAttribute(attr, PROPERTY_STROKE_WIDTH, SVGUtils.formatNumberAttribute(lw));
        }
        this.context.put(SVGContext.LAYER_STROKE_WIDTH, lw);
        SVGUtils.startElement(this.handler, "g", attr);
        Iterator types = layer.getDXFEntityTypeIterator();
        while (types.hasNext()) {
            String type = (String)types.next();
            ArrayList list = (ArrayList)layer.getDXFEntities(type);
            try {
                SVGSAXGenerator gen = this.manager.getSVGGenerator(type);
                for (DXFEntity entity : list) {
                    boolean v = entity.isVisibile();
                    entity.setVisibile(!layer.isFrozen());
                    if (!onModelspace) {
                        entity.setVisibile(layer.isVisible());
                    }
                    if (onModelspace && entity.isModelSpace() || !onModelspace && !entity.isModelSpace()) {
                        gen.toSAX(this.handler, this.context, entity, null);
                    }
                    entity.setVisibile(v);
                }
            }
            catch (SVGGenerationException e) {
                e.printStackTrace();
            }
        }
        SVGUtils.endElement(this.handler, "g");
    }
}

