/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.processing.helper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.kabeja.dxf.DXFArc;
import org.kabeja.dxf.DXFConstants;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFLayer;
import org.kabeja.dxf.DXFLine;
import org.kabeja.dxf.DXFPolyline;
import org.kabeja.dxf.DXFVertex;
import org.kabeja.dxf.helpers.DXFUtils;
import org.kabeja.dxf.helpers.Point;

public class PolylineQueue {
    private List elements = new ArrayList();
    private Point startPoint;
    private Point endPoint;
    private double radius = DXFConstants.POINT_CONNECTION_RADIUS;

    public PolylineQueue(DXFEntity e, Point start, Point end, double radius) {
        this.elements.add(e);
        this.startPoint = start;
        this.endPoint = end;
        this.radius = radius;
    }

    public int size() {
        return this.elements.size();
    }

    public boolean connectDXFEntity(DXFEntity e, Point start, Point end) {
        if (DXFUtils.equals(this.startPoint, end, this.radius)) {
            this.startPoint = start;
            this.elements.add(0, e);
            return true;
        }
        if (DXFUtils.equals(this.endPoint, start, this.radius)) {
            this.endPoint = end;
            this.elements.add(e);
            return true;
        }
        if (DXFUtils.equals(this.startPoint, start, this.radius)) {
            this.startPoint = end;
            this.reverse(e);
            this.elements.add(0, e);
            return true;
        }
        if (DXFUtils.equals(this.endPoint, end, this.radius)) {
            this.endPoint = start;
            this.reverse(e);
            this.elements.add(e);
            return true;
        }
        return false;
    }

    public Point getStartPoint() {
        return this.startPoint;
    }

    public Point getEndPoint() {
        return this.endPoint;
    }

    public Iterator getElementIterator() {
        return this.elements.iterator();
    }

    public boolean connect(PolylineQueue queue) {
        if (DXFUtils.equals(queue.getStartPoint(), this.endPoint, this.radius)) {
            this.add(queue);
            return true;
        }
        if (DXFUtils.equals(queue.getEndPoint(), this.startPoint, this.radius)) {
            this.insertBefore(queue);
            return true;
        }
        if (DXFUtils.equals(queue.getStartPoint(), this.startPoint, this.radius)) {
            queue.reverse();
            this.insertBefore(queue);
            return true;
        }
        if (DXFUtils.equals(queue.getEndPoint(), this.endPoint, this.radius)) {
            queue.reverse();
            this.add(queue);
            return true;
        }
        return false;
    }

    public void createDXFPolyline(DXFLayer layer) {
        DXFPolyline pline = new DXFPolyline();
        DXFVertex first = new DXFVertex(this.startPoint);
        pline.addVertex(first);
        for (DXFEntity e : this.elements) {
            DXFArc arc;
            if ("LINE".equals(e.getType())) {
                DXFLine line = (DXFLine)e;
                first = new DXFVertex(line.getEndPoint());
                pline.addVertex(first);
            } else if ("POLYLINE".equals(e.getType()) || "LWPOLYLINE".equals(e.getType())) {
                DXFPolyline pl = (DXFPolyline)e;
                double bulge = pl.getVertex(0).getBulge();
                if (bulge != 0.0) {
                    first.setBulge(bulge);
                }
                for (int x = 1; x < pl.getVertexCount(); ++x) {
                    first = pl.getVertex(x);
                    pline.addVertex(first);
                }
            } else if ("ARC".equals(e.getType()) && (arc = (DXFArc)e).getTotalAngle() > 0.0) {
                double h = arc.getRadius() * (1.0 - Math.cos(Math.toRadians(arc.getTotalAngle() / 2.0)));
                double chordLength = arc.getChordLength();
                if (DXFUtils.equals(arc.getStartPoint(), first.getPoint(), this.radius)) {
                    first.setBulge(2.0 * h / chordLength);
                    first = new DXFVertex(arc.getEndPoint());
                    pline.addVertex(first);
                } else {
                    first.setBulge(-1.0 * (2.0 * h / chordLength));
                    first = new DXFVertex(arc.getStartPoint());
                    pline.addVertex(first);
                }
            }
            layer.removeDXFEntity(e);
        }
        pline.setLayerName(layer.getName());
        layer.addDXFEntity(pline);
    }

    protected void reverse(DXFEntity entity) {
        if ("LINE".equals(entity.getType())) {
            DXFUtils.reverseDXFLine((DXFLine)entity);
        } else if ("POLYLINE".equals(entity.getType()) || "LWPOLYLINE".equals(entity.getType())) {
            DXFUtils.reverseDXFPolyline((DXFPolyline)entity);
        } else if ("ARC".equals(entity.getType())) {
            // empty if block
        }
    }

    protected void reverse() {
        Point p = this.endPoint;
        this.endPoint = this.startPoint;
        this.startPoint = p;
        int last = this.elements.size() - 1;
        for (int i = 0; i < last + 1; ++i) {
            DXFEntity first = (DXFEntity)this.elements.get(i);
            this.reverse(first);
            if (i >= last) continue;
            DXFEntity e = this.elements.set(last, first);
            this.reverse(e);
            this.elements.set(i, e);
            --last;
        }
    }

    public void insertBefore(PolylineQueue queue) {
        this.startPoint = queue.getStartPoint();
        Iterator i = queue.getElementIterator();
        int x = 0;
        while (i.hasNext()) {
            DXFEntity e = (DXFEntity)i.next();
            this.elements.add(x, e);
            ++x;
        }
    }

    public void add(PolylineQueue queue) {
        this.endPoint = queue.getEndPoint();
        Iterator i = queue.getElementIterator();
        while (i.hasNext()) {
            DXFEntity e = (DXFEntity)i.next();
            this.elements.add(e);
        }
    }
}

