/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.processing;

import java.util.Iterator;
import java.util.Map;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFLayer;
import org.kabeja.dxf.DXFViewport;
import org.kabeja.processing.AbstractPostProcessor;
import org.kabeja.processing.ProcessorException;

public class ViewportFilter
extends AbstractPostProcessor {
    public void process(DXFDocument doc, Map context) throws ProcessorException {
        DXFViewport viewport = null;
        Iterator i = doc.getDXFViewportIterator();
        boolean found = false;
        while (i.hasNext() && !found) {
            DXFViewport v = (DXFViewport)i.next();
            if (!v.isActive()) continue;
            viewport = v;
            found = true;
        }
        if (viewport != null) {
            double h = viewport.getHeight() / 2.0;
            double w = viewport.getHeight() * viewport.getAspectRatio() / 2.0;
            Bounds b = new Bounds();
            b.addToBounds(viewport.getCenterPoint().getX() + w, viewport.getCenterPoint().getY() + h, viewport.getCenterPoint().getZ());
            b.addToBounds(viewport.getCenterPoint().getX() - w, viewport.getCenterPoint().getY() - h, viewport.getCenterPoint().getZ());
            this.filterEntities(b, doc);
        }
    }

    protected void filterEntities(Bounds b, DXFDocument doc) {
        Iterator i = doc.getDXFLayerIterator();
        while (i.hasNext()) {
            DXFLayer l = (DXFLayer)i.next();
            Iterator ti = l.getDXFEntityTypeIterator();
            while (ti.hasNext()) {
                String type = (String)ti.next();
                Iterator ei = l.getDXFEntities(type).iterator();
                while (ei.hasNext()) {
                    DXFEntity entity = (DXFEntity)ei.next();
                    Bounds currentBounds = entity.getBounds();
                    if (b.contains(currentBounds)) continue;
                    ei.remove();
                }
            }
        }
    }

    public void setProperties(Map properties) {
    }
}

