/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.processing;

import java.util.Iterator;
import java.util.Map;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFLayer;
import org.kabeja.dxf.DXFView;
import org.kabeja.processing.AbstractPostProcessor;
import org.kabeja.processing.ProcessorException;

public class ViewFilter
extends AbstractPostProcessor {
    public static final String CONTEXT_OPTION_VIEW_NAME = "view.name";

    public void process(DXFDocument doc, Map context) throws ProcessorException {
        DXFView view = null;
        Iterator i = doc.getDXFViewIterator();
        if (context.containsKey(CONTEXT_OPTION_VIEW_NAME)) {
            String name = (String)context.get(CONTEXT_OPTION_VIEW_NAME);
            boolean found = false;
            while (i.hasNext() && !found) {
                DXFView v = (DXFView)i.next();
                if (!v.getName().trim().equals(name.trim())) continue;
                view = v;
                found = true;
            }
        } else if (i.hasNext()) {
            view = (DXFView)i.next();
        }
        if (view != null) {
            double w = view.getWidth() / 2.0;
            double h = view.getHeight() / 2.0;
            Bounds b = new Bounds();
            b.addToBounds(view.getCenterPoint().getX() + w, view.getCenterPoint().getY() + h, view.getCenterPoint().getZ());
            b.addToBounds(view.getCenterPoint().getX() - w, view.getCenterPoint().getY() - h, view.getCenterPoint().getZ());
            this.filterEntities(b, doc);
        }
    }

    protected void filterEntities(Bounds b, DXFDocument doc) {
        Iterator i = doc.getDXFLayerIterator();
        while (i.hasNext()) {
            DXFLayer l = (DXFLayer)i.next();
            Iterator ti = l.getDXFEntityTypeIterator();
            while (ti.hasNext()) {
                String type = (String)ti.next();
                Iterator ei = l.getDXFEntities(type).iterator();
                while (ei.hasNext()) {
                    DXFEntity entity = (DXFEntity)ei.next();
                    Bounds currentBounds = entity.getBounds();
                    if (b.contains(currentBounds)) continue;
                    ei.remove();
                }
            }
        }
    }

    public void setProperties(Map properties) {
    }
}

