/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.processing;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.processing.PostProcessor;
import org.kabeja.processing.PostProcessorConfig;
import org.kabeja.processing.ProcessingManager;
import org.kabeja.processing.ProcessorException;
import org.kabeja.processing.helper.MergeMap;
import org.kabeja.tools.SAXFilterConfig;
import org.kabeja.xml.SAXFilter;
import org.kabeja.xml.SAXGenerator;
import org.kabeja.xml.SAXSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ProcessPipeline {
    private ProcessingManager manager;
    private List postProcessorConfigs = new ArrayList();
    private List saxFilterConfigs = new ArrayList();
    private SAXGenerator generator;
    private Map serializerProperties = new HashMap();
    private Map generatorProperties = new HashMap();
    private SAXSerializer serializer;
    private String name;
    private String description = "";

    public void process(DXFDocument doc, Map context, OutputStream out) throws ProcessorException {
        ContentHandler handler = null;
        for (PostProcessorConfig ppc : this.postProcessorConfigs) {
            PostProcessor pp = this.manager.getPostProcessor(ppc.getPostProcessorName());
            Map oldProps = pp.getProperties();
            pp.setProperties(new MergeMap(ppc.getProperties(), context));
            pp.process(doc, context);
            pp.setProperties(oldProps);
        }
        ArrayList<Map> saxFilterProperties = new ArrayList<Map>();
        if (this.saxFilterConfigs.size() > 0) {
            Iterator i = this.saxFilterConfigs.iterator();
            SAXFilterConfig sc = (SAXFilterConfig)i.next();
            SAXFilter first = this.manager.getSAXFilter(sc.getFilterName());
            saxFilterProperties.add(new MergeMap(first.getProperties(), context));
            first.setContentHandler(this.serializer);
            handler = first;
            first.setProperties(sc.getProperties());
            while (i.hasNext()) {
                sc = (SAXFilterConfig)i.next();
                SAXFilter f = this.manager.getSAXFilter(sc.getFilterName());
                f.setContentHandler(handler);
                saxFilterProperties.add(f.getProperties());
                f.setProperties(sc.getProperties());
                handler = f;
            }
        } else {
            handler = this.serializer;
        }
        Map oldProbs = this.serializer.getProperties();
        this.serializer.setProperties(new MergeMap(this.serializerProperties, context));
        this.serializer.setOutput(out);
        try {
            Map oldGenProps = this.generator.getProperties();
            this.generator.setProperties(this.generatorProperties);
            this.generator.generate(doc, handler, context);
            this.generator.setProperties(oldGenProps);
        }
        catch (SAXException e) {
            throw new ProcessorException(e);
        }
        this.serializer.setProperties(oldProbs);
        for (int x = 0; x < saxFilterProperties.size(); ++x) {
            SAXFilterConfig sc = (SAXFilterConfig)this.saxFilterConfigs.get(x);
            this.manager.getSAXFilter(sc.getFilterName()).setProperties((Map)saxFilterProperties.get(x));
        }
    }

    public SAXSerializer getSAXSerializer() {
        return this.serializer;
    }

    public void setSAXSerializer(SAXSerializer serializer) {
        this.serializer = serializer;
    }

    public ProcessingManager getProcessorManager() {
        return this.manager;
    }

    public void setProcessorManager(ProcessingManager manager) {
        this.manager = manager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void prepare() {
    }

    public List getPostProcessorConfigs() {
        return this.postProcessorConfigs;
    }

    public void addSAXFilterConfig(SAXFilterConfig config) {
        this.saxFilterConfigs.add(config);
    }

    public void addPostProcessorConfig(PostProcessorConfig config) {
        this.postProcessorConfigs.add(config);
    }

    public Map getSerializerProperties() {
        return this.serializerProperties;
    }

    public void setSAXSerializerProperties(Map serializerProperties) {
        this.serializerProperties = serializerProperties;
    }

    public void setSAXGeneratorProperties(Map generatorProperties) {
        this.generatorProperties = generatorProperties;
    }

    public Map getSAXGeneratorProperties(Map generatorProperties) {
        return this.generatorProperties;
    }

    public void setSAXGenerator(SAXGenerator generator) {
        this.generator = generator;
    }

    public SAXGenerator getSAXGenerator() {
        return this.generator;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

