/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.processing;

import java.util.ArrayList;
import java.util.Map;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.processing.PostProcessor;
import org.kabeja.processing.ProcessorException;

public class PostProcessManager {
    private ArrayList processors = new ArrayList();

    public void addPostProcessor(PostProcessor pp) {
        this.processors.add(pp);
    }

    public void addPostProcessor(String classname) {
        try {
            PostProcessor pp = (PostProcessor)this.getClass().getClassLoader().loadClass(classname).newInstance();
            this.addPostProcessor(pp);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void process(DXFDocument doc, Map context) throws ProcessorException {
        for (PostProcessor pp : this.processors) {
            pp.process(doc, context);
        }
    }
}

