/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.processing;

import java.util.Iterator;
import java.util.Map;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFLayer;
import org.kabeja.processing.AbstractPostProcessor;
import org.kabeja.processing.ProcessorException;

public class BoundsFilter
extends AbstractPostProcessor {
    public static final String PROPERTY_X = "boundsfilter.x";
    public static final String PROPERTY_Y = "boundsfilter.y";
    public static final String PROPERTY_WIDTH = "boundsfilter.width";
    public static final String PROPERTY_HEIGHT = "boundsfilter.height";
    public static final String PROPERTY_PROCESS = "boundsfilter.process";

    public void process(DXFDocument doc, Map context) throws ProcessorException {
        if (this.properties.containsKey(PROPERTY_PROCESS) && Boolean.valueOf((String)this.properties.get(PROPERTY_PROCESS)).booleanValue()) {
            Bounds bounds = new Bounds();
            if (this.properties.containsKey(PROPERTY_X)) {
                bounds.setMinimumX(Double.parseDouble((String)this.properties.get(PROPERTY_X)));
            }
            if (this.properties.containsKey(PROPERTY_Y)) {
                bounds.setMinimumY(Double.parseDouble((String)this.properties.get(PROPERTY_Y)));
            }
            if (this.properties.containsKey(PROPERTY_WIDTH)) {
                bounds.setMaximumX(bounds.getMinimumX() + Double.parseDouble((String)this.properties.get(PROPERTY_WIDTH)));
            }
            if (this.properties.containsKey(PROPERTY_WIDTH)) {
                bounds.setMaximumY(bounds.getMinimumY() + Double.parseDouble((String)this.properties.get(PROPERTY_HEIGHT)));
            }
            Iterator i = doc.getDXFLayerIterator();
            while (i.hasNext()) {
                DXFLayer layer = (DXFLayer)i.next();
                this.filterLayer(layer, bounds);
            }
        }
    }

    protected void filterLayer(DXFLayer layer, Bounds bounds) {
        Iterator i = layer.getDXFEntityTypeIterator();
        while (i.hasNext()) {
            String type = (String)i.next();
            Iterator entities = layer.getDXFEntities(type).iterator();
            while (entities.hasNext()) {
                DXFEntity entity = (DXFEntity)entities.next();
                if (bounds.enclose(entity.getBounds())) continue;
                entities.remove();
            }
        }
    }
}

