/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.table;

import org.kabeja.dxf.DXFLayer;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.table.AbstractTableHandler;

public class DXFLayerTableHandler
extends AbstractTableHandler {
    public static final String TABLE_KEY = "LAYER";
    public static final int GROUPCODE_LAYER_NAME = 2;
    public static final int GROUPCODE_LAYER_LINETYPE = 6;
    public static final int GROUPCODE_LAYER_COLORNUMBER = 62;
    public static final int GROUPCODE_LAYER_PLOTTINGFLAG = 290;
    public static final int GROUPCODE_LAYER_LINEWEIGHT = 370;
    public static final int GROUPCODE_LAYER_PLOTSTYLENAME = 390;
    private DXFLayer layer;

    public String getTableKey() {
        return TABLE_KEY;
    }

    public void parseGroup(int groupCode, DXFValue value) {
        switch (groupCode) {
            case 2: {
                this.layer.setName(value.getValue());
                break;
            }
            case 62: {
                this.layer.setColor(value.getIntegerValue());
                break;
            }
            case 6: {
                this.layer.setLineType(value.getValue());
                break;
            }
            case 70: {
                this.layer.setFlags(value.getIntegerValue());
                break;
            }
            case 370: {
                this.layer.setLineWeight(value.getIntegerValue());
                break;
            }
            case 390: {
                this.layer.setPlotStyle(value.getValue());
            }
        }
    }

    public void endParsing() {
        this.doc.addDXFLayer(this.layer);
    }

    public void startParsing() {
        this.layer = new DXFLayer();
        this.layer.setDXFDocument(this.doc);
    }
}

