/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.objects;

import org.kabeja.dxf.objects.DXFObject;
import org.kabeja.dxf.objects.DXFPlotSettings;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.objects.AbstractDXFObjectHandler;

public class DXFPlotsettingsHandler
extends AbstractDXFObjectHandler {
    public static final int GROUPCODE_NAME = 1;
    public static final int GROUPCODE_PLOT_CONFIGURATION_FILE = 2;
    public static final int GROUPCODE_PAPER_SIZE = 4;
    public static final int GROUPCODE_PLOT_VIEW_NAME = 6;
    public static final int GROUPCODE_MARGIN_LEFT = 40;
    public static final int GROUPCODE_MARGIN_BOTTOM = 41;
    public static final int GROUPCODE_MARGIN_RIGHT = 42;
    public static final int GROUPCODE_MARGIN_TOP = 43;
    public static final int GROUPCODE_PLOT_PAPER_WIDTH = 44;
    public static final int GROUPCODE_PLOT_PAPER_HEIGHT = 45;
    public static final int GROUPCODE_ORIGIN_X = 46;
    public static final int GROUPCODE_ORIGIN_Y = 47;
    public static final int GROUPCODE_PLOT_WINDOW_MIN_X = 48;
    public static final int GROUPCODE_PLOT_WINDOWS_MIN_Y = 49;
    public static final int GROUPCODE_PLOT_WINDOW_MAX_X = 140;
    public static final int GROUPCODE_PLOT_WINDOWS_MAX_Y = 141;
    public static final int GROUPCODE_CUSTOM_SCALE_NUMERATOR = 142;
    public static final int GROUPCODE_CUSTOM_SCALE_DEOMINATOR = 143;
    public static final int GROUPCODE_PAPER_UNITS = 72;
    public static final int GROUPCODE_PLOT_ROTATION = 73;
    public static final int GROUPCODE_PLOT_TYPE = 74;
    public static final int GROUPCODE_CURRENT_STYLESHEET = 7;
    public static final int GROUPCODE_STANDARD_SCALE_TYPE = 75;
    protected DXFPlotSettings plotSettings;

    public void endObject() {
    }

    public DXFObject getDXFObject() {
        return this.plotSettings;
    }

    public String getObjectType() {
        return "PLOTSETTINGS";
    }

    public void parseGroup(int groupCode, DXFValue value) {
        switch (groupCode) {
            case 7: {
                this.plotSettings.setCurrentStylesheet(value.getValue());
                break;
            }
            case 143: {
                this.plotSettings.setCustomScaleDenominator(value.getDoubleValue());
                break;
            }
            case 142: {
                this.plotSettings.setCustomScaleNumerator(value.getDoubleValue());
                break;
            }
            case 41: {
                double[] m = this.plotSettings.getMargin();
                m[2] = value.getDoubleValue();
                this.plotSettings.setMargin(m);
                break;
            }
            case 40: {
                double[] m = this.plotSettings.getMargin();
                m[3] = value.getDoubleValue();
                this.plotSettings.setMargin(m);
                break;
            }
            case 42: {
                double[] m = this.plotSettings.getMargin();
                m[1] = value.getDoubleValue();
                this.plotSettings.setMargin(m);
                break;
            }
            case 43: {
                double[] m = this.plotSettings.getMargin();
                m[0] = value.getDoubleValue();
                this.plotSettings.setMargin(m);
                break;
            }
            case 46: {
                this.plotSettings.getPlotOrigin().setX(value.getDoubleValue());
                break;
            }
            case 47: {
                this.plotSettings.getPlotOrigin().setY(value.getDoubleValue());
                break;
            }
            case 1: {
                this.plotSettings.setName(value.getValue());
                break;
            }
            case 4: {
                break;
            }
            case 72: {
                this.plotSettings.setPaperUnit(value.getIntegerValue());
                break;
            }
            case 2: {
                break;
            }
            case 45: {
                this.plotSettings.setPaperHeight(value.getDoubleValue());
                break;
            }
            case 44: {
                this.plotSettings.setPaperWidth(value.getDoubleValue());
                break;
            }
            case 73: {
                this.plotSettings.setPlotRotation(value.getIntegerValue());
                break;
            }
            case 74: {
                this.plotSettings.setPlotType(value.getIntegerValue());
                break;
            }
            case 6: {
                this.plotSettings.setPlotViewName(value.getValue());
                break;
            }
            case 140: {
                this.plotSettings.getWindowToPlot().setMaximumX(value.getDoubleValue());
                break;
            }
            case 48: {
                this.plotSettings.getWindowToPlot().setMinimumX(value.getDoubleValue());
                break;
            }
            case 141: {
                this.plotSettings.getWindowToPlot().setMaximumY(value.getDoubleValue());
                break;
            }
            case 49: {
                this.plotSettings.getWindowToPlot().setMinimumY(value.getDoubleValue());
                break;
            }
            default: {
                super.parseCommonGroupCode(groupCode, value, this.plotSettings);
            }
        }
    }

    public void startObject() {
        this.plotSettings = new DXFPlotSettings();
    }
}

