/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.objects;

import org.kabeja.dxf.objects.DXFMLineStyle;
import org.kabeja.dxf.objects.DXFMLineStyleElement;
import org.kabeja.dxf.objects.DXFObject;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.objects.AbstractDXFObjectHandler;

public class DXFMLineStyleHandler
extends AbstractDXFObjectHandler {
    public static final int GROUPCODE_MLINE_STYLE_NAME = 2;
    public static final int GROUPCODE_MLINE_STYLE_FLAGS = 70;
    public static final int GROUPCODE_MLINE_STYLE_DESCRIPTION = 3;
    public static final int GROUPCODE_MLINE_STYLE_FILL_COLOR = 62;
    public static final int GROUPCODE_MLINE_STYLE_START_ANGLE = 51;
    public static final int GROUPCODE_MLINE_STYLE_END_ANGLE = 52;
    public static final int GROUPCODE_MLINE_STYLE_ELEMENT_COUNT = 71;
    public static final int GROUPCODE_MLINE_STYLE_ELEMENT_OFFSET = 49;
    public static final int GROUPCODE_MLINE_STYLE_ELEMENT_COLOR = 62;
    public static final int GROUPCODE_MLINE_STYLE_ELEMENT_LINE_STYLE = 6;
    protected DXFMLineStyle style;
    protected DXFMLineStyleElement element;
    protected boolean processLineElement = false;

    public void endObject() {
    }

    public DXFObject getDXFObject() {
        return this.style;
    }

    public String getObjectType() {
        return "MLINESTYLE";
    }

    public void parseGroup(int groupCode, DXFValue value) {
        switch (groupCode) {
            case 49: {
                this.element = new DXFMLineStyleElement();
                this.element.setOffset(value.getDoubleValue());
                this.style.addDXFMLineStyleElement(this.element);
                this.processLineElement = true;
                break;
            }
            case 62: {
                if (this.processLineElement) {
                    this.element.setLineColor(value.getIntegerValue());
                    break;
                }
                this.style.setFillColor(value.getIntegerValue());
                break;
            }
            case 6: {
                this.element.setLineType(value.getValue());
                break;
            }
            case 2: {
                this.style.setName(value.getValue());
                break;
            }
            case 3: {
                this.style.setDescrition(value.getValue());
                break;
            }
            case 51: {
                this.style.setStartAngle(value.getDoubleValue());
                break;
            }
            case 52: {
                this.style.setEndAngle(value.getDoubleValue());
                break;
            }
            case 70: {
                this.style.setFlags(value.getIntegerValue());
                break;
            }
            default: {
                super.parseCommonGroupCode(groupCode, value, this.style);
            }
        }
    }

    public void startObject() {
        this.style = new DXFMLineStyle();
        this.processLineElement = false;
    }
}

