/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.objects;

import org.kabeja.dxf.objects.DXFLayout;
import org.kabeja.dxf.objects.DXFObject;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.objects.DXFPlotsettingsHandler;

public class DXFLayoutHandler
extends DXFPlotsettingsHandler {
    public static final int GROUPCODE_MINIMUM_LIMITS_X = 10;
    public static final int GROUPCODE_MINIMUM_LIMITS_Y = 20;
    public static final int GROUPCODE_MAXIMUM_LIMITS_X = 11;
    public static final int GROUPCODE_MAXIMUM_LIMITS_Y = 21;
    public static final int GROUPCODE_INSERT_POINT_X = 12;
    public static final int GROUPCODE_INSERT_POINT_Y = 22;
    public static final int GROUPCODE_INSERT_POINT_Z = 32;
    public static final int GROUPCODE_MINIMUM_EXTENTS_X = 14;
    public static final int GROUPCODE_MINIMUM_EXTENTS_Y = 24;
    public static final int GROUPCODE_MINIMUM_EXTENTS_Z = 34;
    public static final int GROUPCODE_MAXIMUM_EXTENTS_X = 15;
    public static final int GROUPCODE_MAXIMUM_EXTENTS_Y = 25;
    public static final int GROUPCODE_MAXIMUM_EXTENTS_Z = 35;
    public static final int GROUPCODE_ELEVATION = 146;
    public static final int GROUPCODE_UCS_ORIGIN_X = 13;
    public static final int GROUPCODE_UCS_ORIGIN_Y = 23;
    public static final int GROUPCODE_UCS_ORIGIN_Z = 33;
    public static final int GROUPCODE_UCS_AXIS_X_X = 16;
    public static final int GROUPCODE_UCS_AXIS_X_Y = 26;
    public static final int GROUPCODE_UCS_AXIS_X_Z = 36;
    public static final int GROUPCODE_UCS_AXIS_Y_X = 17;
    public static final int GROUPCODE_UCS_AXIS_Y_Y = 27;
    public static final int GROUPCODE_UCS_AXIS_Y_Z = 37;
    public static final int GROUPCODE_UCS_ORTHOGRAPHIC_TYPE = 76;
    public static final int GROUPCODE_PAPER_SPACE_BLOCK_RECORD_ID = 330;
    public static final int GROUPCODE_LAST_ACTIVE_VIEWPORT_ID = 331;
    public static final int GROUPCODE_UCS_ID = 345;
    public static final int GROUPCODE_UCS_BASE_ID = 346;
    protected DXFLayout layout;

    public void endObject() {
    }

    public DXFObject getDXFObject() {
        return this.layout;
    }

    public String getObjectType() {
        return "LAYOUT";
    }

    public void parseGroup(int groupCode, DXFValue value) {
        switch (groupCode) {
            case 146: {
                this.layout.setElevation(value.getDoubleValue());
                break;
            }
            case 12: {
                this.layout.getInsertPoint().setX(value.getDoubleValue());
                break;
            }
            case 22: {
                this.layout.getInsertPoint().setY(value.getDoubleValue());
                break;
            }
            case 32: {
                this.layout.getInsertPoint().setZ(value.getDoubleValue());
                break;
            }
            case 331: {
                this.layout.setLastActiveViewportID(value.getValue());
                break;
            }
            case 15: {
                this.layout.getExtent().setMaximumX(value.getDoubleValue());
                break;
            }
            case 25: {
                this.layout.getExtent().setMaximumY(value.getDoubleValue());
                break;
            }
            case 35: {
                this.layout.getExtent().setMaximumZ(value.getDoubleValue());
                break;
            }
            case 11: {
                this.layout.getLimits().setMaximumX(value.getDoubleValue());
                break;
            }
            case 21: {
                this.layout.getLimits().setMaximumY(value.getDoubleValue());
                break;
            }
            case 14: {
                this.layout.getExtent().setMinimumX(value.getDoubleValue());
                break;
            }
            case 24: {
                this.layout.getExtent().setMinimumY(value.getDoubleValue());
                break;
            }
            case 34: {
                this.layout.getExtent().setMinimumZ(value.getDoubleValue());
                break;
            }
            case 10: {
                this.layout.getLimits().setMinimumX(value.getDoubleValue());
                break;
            }
            case 20: {
                this.layout.getLimits().setMinimumY(value.getDoubleValue());
                break;
            }
            case 330: {
                this.layout.setPaperSpaceBlockID(value.getValue());
                break;
            }
            case 16: {
                this.layout.getXAxisUCS().setX(value.getDoubleValue());
                break;
            }
            case 26: {
                this.layout.getXAxisUCS().setY(value.getDoubleValue());
                break;
            }
            case 36: {
                this.layout.getXAxisUCS().setZ(value.getDoubleValue());
                break;
            }
            case 17: {
                this.layout.getYAxisUCS().setX(value.getDoubleValue());
                break;
            }
            case 27: {
                this.layout.getYAxisUCS().setY(value.getDoubleValue());
                break;
            }
            case 37: {
                this.layout.getYAxisUCS().setZ(value.getDoubleValue());
                break;
            }
            case 346: {
                this.layout.setBaseUCSID(value.getValue());
                break;
            }
            case 345: {
                this.layout.setNamedUCSID(value.getValue());
                break;
            }
            case 13: {
                this.layout.getOriginUCS().setX(value.getDoubleValue());
                break;
            }
            case 23: {
                this.layout.getOriginUCS().setY(value.getDoubleValue());
                break;
            }
            case 33: {
                this.layout.getOriginUCS().setZ(value.getDoubleValue());
                break;
            }
            case 76: {
                this.layout.setOrthographicTypeOfUCS(value.getIntegerValue());
                break;
            }
            default: {
                super.parseGroup(groupCode, value);
            }
        }
    }

    public void startObject() {
        this.layout = new DXFLayout();
        this.plotSettings = this.layout;
    }
}

