/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.entities;

import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFViewport;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.entities.AbstractEntityHandler;

public class DXFViewportHandler
extends AbstractEntityHandler {
    public static final int GROUPCODE_CENTER_X = 10;
    public static final int GROUPCODE_CENTER_Y = 20;
    public static final int GROUPCODE_CENTER_Z = 30;
    public static final int GROUPCODE_HEIGHT = 41;
    public static final int GROUPCODE_WIDTH = 40;
    public static final int GROUPCODE_VIEW_DIRECTION_X = 16;
    public static final int GROUPCODE_VIEW_DIRECTION_Y = 26;
    public static final int GROUPCODE_VIEW_DIRECTION_Z = 36;
    public static final int GROUPCODE_VIEW_CENTER_X = 12;
    public static final int GROUPCODE_VIEW_CENTER_Y = 22;
    public static final int GROUPCODE_VIEW_CENTER_Z = 32;
    public static final int GROUPCODE_VIEW_TARGET_X = 17;
    public static final int GROUPCODE_VIEW_TARGET_Y = 27;
    public static final int GROUPCODE_VIEW_TARGET_Z = 37;
    public static final int GROUPCODE_SNAP_BASE_POINT_X = 13;
    public static final int GROUPCODE_SNAP_BASE_POINT_Y = 23;
    public static final int GROUPCODE_SNAP_SPACING_X = 14;
    public static final int GROUPCODE_SNAP_SPACING_Y = 24;
    public static final int GROUPCODE_GRID_SPACING_X = 15;
    public static final int GROUPCODE_GRID_SPACING_Y = 25;
    public static final int GROUPCODE_LENS_LENGTH = 42;
    public static final int GROUPCODE_FRONT_CLIPPING = 43;
    public static final int GROUPCODE_BACK_CLIPPING = 44;
    public static final int GROUPCODE_VIEW_HEIGHT = 45;
    public static final int GROUPCODE_SNAP_ANGLE = 50;
    public static final int GROUPCODE_TWIST_ANGLE = 51;
    public static final int GROUPCODE_RENDER_MODE = 281;
    public static final int GROUPCODE_UCS_ORIGIN_X = 110;
    public static final int GROUPCODE_UCS_ORIGIN_Y = 120;
    public static final int GROUPCODE_UCS_ORIGIN_Z = 130;
    public static final int GROUPCODE_UCS_X_AXIS_X = 111;
    public static final int GROUPCODE_UCS_X_AXIS_Y = 121;
    public static final int GROUPCODE_UCS_X_AXIS_Z = 131;
    public static final int GROUPCODE_UCS_Y_AXIS_X = 112;
    public static final int GROUPCODE_UCS_Y_AXIS_Y = 122;
    public static final int GROUPCODE_UCS_Y_AXIS_Z = 132;
    public static final int GROUPCODE_UCS_TYPE = 79;
    public static final int GROUPCODE_UCS_ELEVATION = 146;
    public static final int GROUPCODE_CIRCLE_ZOOM_PERCENT = 72;
    public static final int GROUPCODE_VIEWPORT_ID = 69;
    public static final int GROUPCODE_VIEWPORT_STATUS = 68;
    public static final int GROUPCODE_PLOTSTYLE_NAME = 1;
    public static final int GROUPCODE_FROZEN_LAYER = 341;
    public static final int GROUPCODE_FROZEN_LAYER_XDATA = 1003;
    private int[] xDataConvert = new int[]{1000, 1002, 1070, 17, 27, 37, 16, 26, 36, 51, 45, 12, 22, 42, 43, 44, 90, 72, 90, 90, 90, 90, 90, 90, 50, 13, 23, 14, 24, 15, 25, 90, 1002};
    private DXFViewport viewport;
    private boolean convertXDATA = false;
    private int pos = 0;

    public void parseGroup(int groupCode, DXFValue value) {
        if (this.convertXDATA && this.pos < this.xDataConvert.length) {
            groupCode = this.xDataConvert[this.pos];
            ++this.pos;
        } else if (groupCode == 1001 && value.getValue().equals("ACAD")) {
            this.convertXDATA = true;
            this.pos = 0;
        } else {
            this.convertXDATA = false;
        }
        switch (groupCode) {
            case 10: {
                this.viewport.getCenterPoint().setX(value.getDoubleValue());
                break;
            }
            case 20: {
                this.viewport.getCenterPoint().setY(value.getDoubleValue());
                break;
            }
            case 30: {
                this.viewport.getCenterPoint().setZ(value.getDoubleValue());
                break;
            }
            case 12: {
                this.viewport.getViewCenterPoint().setX(value.getDoubleValue());
                break;
            }
            case 22: {
                this.viewport.getViewCenterPoint().setY(value.getDoubleValue());
                break;
            }
            case 32: {
                this.viewport.getViewCenterPoint().setZ(value.getDoubleValue());
                break;
            }
            case 16: {
                this.viewport.getViewDirectionVector().setX(value.getDoubleValue());
                break;
            }
            case 26: {
                this.viewport.getViewDirectionVector().setY(value.getDoubleValue());
                break;
            }
            case 36: {
                this.viewport.getViewDirectionVector().setZ(value.getDoubleValue());
                break;
            }
            case 17: {
                this.viewport.getViewTargetPoint().setX(value.getDoubleValue());
                break;
            }
            case 27: {
                this.viewport.getViewTargetPoint().setY(value.getDoubleValue());
                break;
            }
            case 37: {
                this.viewport.getViewTargetPoint().setZ(value.getDoubleValue());
                break;
            }
            case 13: {
                this.viewport.getSnapBasePoint().setX(value.getDoubleValue());
                break;
            }
            case 23: {
                this.viewport.getSnapBasePoint().setY(value.getDoubleValue());
                break;
            }
            case 14: {
                this.viewport.getSnapSpacingPoint().setX(value.getDoubleValue());
                break;
            }
            case 24: {
                this.viewport.getSnapSpacingPoint().setY(value.getDoubleValue());
                break;
            }
            case 15: {
                this.viewport.getGridSpacingPoint().setX(value.getDoubleValue());
                break;
            }
            case 25: {
                this.viewport.getGridSpacingPoint().setY(value.getDoubleValue());
                break;
            }
            case 69: {
                this.viewport.setViewportID(value.getValue());
                break;
            }
            case 40: {
                this.viewport.setWidth(value.getDoubleValue());
                break;
            }
            case 41: {
                this.viewport.setHeight(value.getDoubleValue());
                break;
            }
            case 43: {
                this.viewport.setFrontClippingPlane(value.getDoubleValue());
                break;
            }
            case 44: {
                this.viewport.setBackClippingPlane(value.getDoubleValue());
                break;
            }
            case 42: {
                this.viewport.setLensLength(value.getDoubleValue());
                break;
            }
            case 281: {
                this.viewport.setRenderMode(value.getIntegerValue());
                break;
            }
            case 51: {
                this.viewport.setTwistAngle(value.getDoubleValue());
                break;
            }
            case 50: {
                this.viewport.setSnapAngle(value.getDoubleValue());
                break;
            }
            case 72: {
                this.viewport.setCircleZoom(value.getDoubleValue());
                break;
            }
            case 146: {
                this.viewport.setUcsElevation(value.getDoubleValue());
                break;
            }
            case 110: {
                this.viewport.getUcsOrigin().setX(value.getDoubleValue());
                break;
            }
            case 120: {
                this.viewport.getUcsOrigin().setY(value.getDoubleValue());
                break;
            }
            case 130: {
                this.viewport.getUcsOrigin().setZ(value.getDoubleValue());
                break;
            }
            case 111: {
                this.viewport.getUcsXAxis().setX(value.getDoubleValue());
                break;
            }
            case 121: {
                this.viewport.getUcsXAxis().setY(value.getDoubleValue());
                break;
            }
            case 131: {
                this.viewport.getUcsXAxis().setZ(value.getDoubleValue());
                break;
            }
            case 112: {
                this.viewport.getUcsYAxis().setX(value.getDoubleValue());
                break;
            }
            case 122: {
                this.viewport.getUcsYAxis().setY(value.getDoubleValue());
                break;
            }
            case 132: {
                this.viewport.getUcsYAxis().setZ(value.getDoubleValue());
                break;
            }
            case 79: {
                this.viewport.setUcsType(value.getIntegerValue());
                break;
            }
            case 45: {
                this.viewport.setViewHeight(value.getDoubleValue());
                break;
            }
            case 68: {
                this.viewport.setViewportStatus(value.getIntegerValue());
                break;
            }
            case 1: {
                this.viewport.setPlotStyleName(value.getValue());
                break;
            }
            case 341: {
                this.viewport.addFrozenLayer(value.getValue());
                break;
            }
            case 1003: {
                this.viewport.addFrozenLayer(value.getValue());
                break;
            }
            default: {
                super.parseCommonProperty(groupCode, value, this.viewport);
            }
        }
    }

    public String getDXFEntityName() {
        return "VIEWPORT";
    }

    public void endDXFEntity() {
    }

    public DXFEntity getDXFEntity() {
        return this.viewport;
    }

    public boolean isFollowSequence() {
        return false;
    }

    public void startDXFEntity() {
        this.viewport = new DXFViewport();
        this.viewport.setModelSpace(false);
    }
}

