/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.entities;

import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFTolerance;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.entities.AbstractEntityHandler;

public class DXFToleranceHandler
extends AbstractEntityHandler {
    public static final int GROUPCODE_X_AXIS_DIRECTOPN_X = 11;
    public static final int GROUPCODE_X_AXIS_DIRECTOPN_Y = 21;
    public static final int GROUPCODE_X_AXIS_DIRECTOPN_Z = 31;
    protected DXFTolerance tolerance;

    public String getDXFEntityName() {
        return "TOLERANCE";
    }

    public void endDXFEntity() {
    }

    public DXFEntity getDXFEntity() {
        return this.tolerance;
    }

    public boolean isFollowSequence() {
        return false;
    }

    public void parseGroup(int groupCode, DXFValue value) {
        switch (groupCode) {
            case 10: {
                this.tolerance.getInsertionPoint().setX(value.getDoubleValue());
                break;
            }
            case 20: {
                this.tolerance.getInsertionPoint().setY(value.getDoubleValue());
                break;
            }
            case 30: {
                this.tolerance.getInsertionPoint().setZ(value.getDoubleValue());
                break;
            }
            case 11: {
                this.tolerance.getXaxisDirection().setX(value.getDoubleValue());
                break;
            }
            case 21: {
                this.tolerance.getXaxisDirection().setY(value.getDoubleValue());
                break;
            }
            case 31: {
                this.tolerance.getXaxisDirection().setZ(value.getDoubleValue());
                break;
            }
            case 1: {
                this.tolerance.setText(value.getValue());
                break;
            }
            case 3: {
                this.tolerance.setStyleID(value.getValue());
                break;
            }
            default: {
                super.parseCommonProperty(groupCode, value, this.tolerance);
            }
        }
    }

    public void startDXFEntity() {
        this.tolerance = new DXFTolerance();
    }
}

