/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.entities;

import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFShape;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.entities.AbstractEntityHandler;

public class DXFShapeHandler
extends AbstractEntityHandler {
    public static final int GROUPCODE_NAME = 2;
    public static final int GROUPCODE_SIZE = 40;
    public static final int GROUPCODE_SCALE_X = 41;
    public static final int GROUPCODE_OBLIQUE_ANGLE = 51;
    protected DXFShape shape;

    public String getDXFEntityName() {
        return "SHAPE";
    }

    public void endDXFEntity() {
    }

    public DXFEntity getDXFEntity() {
        return this.shape;
    }

    public boolean isFollowSequence() {
        return false;
    }

    public void parseGroup(int groupCode, DXFValue value) {
        switch (groupCode) {
            case 10: {
                this.shape.getInsertPoint().setX(value.getDoubleValue());
                break;
            }
            case 20: {
                this.shape.getInsertPoint().setY(value.getDoubleValue());
                break;
            }
            case 30: {
                this.shape.getInsertPoint().setZ(value.getDoubleValue());
                break;
            }
            case 51: {
                this.shape.setObliqueAngle(value.getDoubleValue());
                break;
            }
            case 50: {
                this.shape.setRotation(value.getDoubleValue());
                break;
            }
            case 2: {
                this.shape.setName(value.getValue());
                break;
            }
            case 40: {
                this.shape.setHeight(value.getDoubleValue());
                break;
            }
            default: {
                super.parseCommonProperty(groupCode, value, this.shape);
            }
        }
    }

    public void startDXFEntity() {
        this.shape = new DXFShape();
    }
}

