/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.entities;

import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFMLine;
import org.kabeja.dxf.helpers.DXFMLineSegment;
import org.kabeja.dxf.helpers.DXFMLineSegmentElement;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.entities.AbstractEntityHandler;

public class DXFMLineHandler
extends AbstractEntityHandler {
    public static final int GROUPCODE_MLINE_STYLENAME = 2;
    public static final int GROUPCODE_MLINE_STYLE_ID = 340;
    public static final int GROUPCODE_MLINE_SCALE_FACTOR = 40;
    public static final int GROUPCODE_MLINE_JUSTIFICATION = 70;
    public static final int GROUPCODE_MLINE_FLAGS = 71;
    public static final int GROUPCODE_MLINE_NUMBER_OF_VERTICES = 72;
    public static final int GROUPCODE_MLINE_NUMBER_OF_LINESTYLEELEMENTS = 73;
    public static final int GROUPCODE_MLINE_VERTEX_X = 11;
    public static final int GROUPCODE_MLINE_VERTEX_Y = 21;
    public static final int GROUPCODE_MLINE_VERTEX_Z = 31;
    public static final int GROUPCODE_MLINE_DIRECTION_X = 12;
    public static final int GROUPCODE_MLINE_DIRECTION_Y = 22;
    public static final int GROUPCODE_MLINE_DIRECTION_Z = 32;
    public static final int GROUPCODE_MLINE_MITER_DIRECTION_X = 13;
    public static final int GROUPCODE_MLINE_MITER_DIRECTION_Y = 23;
    public static final int GROUPCODE_MLINE_MITER_DIRECTION_Z = 33;
    public static final int GROUPCODE_MLINE_ELEMENT_PARAMETER_COUNT = 74;
    public static final int GROUPCODE_MLINE_ELEMENT_PARAMETER = 41;
    public static final int GROUPCODE_MLINE_FILL_PARAMETER_COUNT = 75;
    public static final int GROUPCODE_MLINE_FILL_PARAMETER = 42;
    protected DXFMLine mLine;
    protected DXFMLineSegment seg;
    protected DXFMLineSegmentElement el;
    protected int index = 0;

    public String getDXFEntityName() {
        return "MLINE";
    }

    public void endDXFEntity() {
    }

    public DXFEntity getDXFEntity() {
        return this.mLine;
    }

    public boolean isFollowSequence() {
        return false;
    }

    public void parseGroup(int groupCode, DXFValue value) {
        switch (groupCode) {
            case 11: {
                this.seg = new DXFMLineSegment();
                this.mLine.addDXFMLineSegement(this.seg);
                this.seg.getStartPoint().setX(value.getDoubleValue());
                break;
            }
            case 21: {
                this.seg.getStartPoint().setY(value.getDoubleValue());
                break;
            }
            case 31: {
                this.seg.getStartPoint().setZ(value.getDoubleValue());
                break;
            }
            case 12: {
                this.seg.getDirection().setX(value.getDoubleValue());
                break;
            }
            case 22: {
                this.seg.getDirection().setY(value.getDoubleValue());
                break;
            }
            case 32: {
                this.seg.getDirection().setZ(value.getDoubleValue());
                break;
            }
            case 13: {
                this.seg.getMiterDirection().setX(value.getDoubleValue());
                break;
            }
            case 23: {
                this.seg.getMiterDirection().setY(value.getDoubleValue());
                break;
            }
            case 33: {
                this.seg.getMiterDirection().setZ(value.getDoubleValue());
                break;
            }
            case 41: {
                this.el.setLengthParameter(this.index, value.getDoubleValue());
                ++this.index;
                break;
            }
            case 74: {
                this.el = new DXFMLineSegmentElement();
                this.seg.addDXFMLineSegmentElement(this.el);
                this.el.setLengthParameters(new double[value.getIntegerValue()]);
                this.index = 0;
                break;
            }
            case 42: {
                this.el.setFillParameter(this.index, value.getDoubleValue());
                ++this.index;
                break;
            }
            case 75: {
                this.el.setFillParameters(new double[value.getIntegerValue()]);
                this.index = 0;
                break;
            }
            case 10: {
                this.mLine.getStartPoint().setX(value.getDoubleValue());
                break;
            }
            case 20: {
                this.mLine.getStartPoint().setY(value.getDoubleValue());
                break;
            }
            case 30: {
                this.mLine.getStartPoint().setZ(value.getDoubleValue());
                break;
            }
            case 71: {
                this.mLine.setFlags(value.getIntegerValue());
                break;
            }
            case 70: {
                this.mLine.setJustification(value.getIntegerValue());
                break;
            }
            case 73: {
                this.mLine.setLineCount(value.getIntegerValue());
                break;
            }
            case 40: {
                this.mLine.setScale(value.getDoubleValue());
                break;
            }
            case 2: {
                this.mLine.setMLineStyleName(value.getValue());
                break;
            }
            case 340: {
                this.mLine.setMLineStyleID(value.getValue());
                break;
            }
            default: {
                super.parseCommonProperty(groupCode, value, this.mLine);
            }
        }
    }

    public void startDXFEntity() {
        this.mLine = new DXFMLine();
    }
}

