/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.entities;

import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFLeader;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.entities.AbstractEntityHandler;

public class DXFLeaderHandler
extends AbstractEntityHandler {
    public static final int GROUPCODE_ARROW_HEAD_FLAG = 71;
    public static final int GROUPCODE_LEADER_PATH_TYPE = 72;
    public static final int GROUPCODE_LEADER_CREATION_FLAG = 73;
    public static final int GROUPCODE_HOOKLINE_DIRECTION_FLAG = 74;
    public static final int GROUPCODE_HOOKLINE_FLAG = 75;
    public static final int GROUPCODE_TEXT_HEIGHT = 40;
    public static final int GROUPCODE_TEXT_WIDTH = 41;
    public static final int GROUPCODE_COLOR_LEADER = 77;
    public static final int GROUPCODE_TEXT_ENTITY_REFERENCE = 340;
    public static final int GROUPCODE_HORIZONTAL_DIRECTION_X = 211;
    public static final int GROUPCODE_HORIZONTAL_DIRECTION_Y = 221;
    public static final int GROUPCODE_HORIZONTAL_DIRECTION_Z = 231;
    public static final int GROUPCODE_OFFSET_LAST_VERTEX_INSERTPOINT_X = 212;
    public static final int GROUPCODE_OFFSET_LAST_VERTEX_INSERTPOINT_Y = 222;
    public static final int GROUPCODE_OFFSET_LAST_VERTEX_INSERTPOINT_Z = 232;
    public static final int GROUPCODE_OFFSET_LAST_VERTEX_PLACEMENT_POINT_X = 213;
    public static final int GROUPCODE_OFFSET_LAST_VERTEX_PLACEMENT_POINT_Y = 223;
    public static final int GROUPCODE_OFFSET_LAST_VERTEX_PLACEMENT_POINT_Z = 233;
    protected DXFLeader leader;
    protected Point vertex;

    public String getDXFEntityName() {
        return "LEADER";
    }

    public void startDXFEntity() {
        this.leader = new DXFLeader();
    }

    public void parseGroup(int groupCode, DXFValue value) {
        switch (groupCode) {
            case 10: {
                this.vertex = new Point();
                this.leader.addCoordinate(this.vertex);
                this.vertex.setX(value.getDoubleValue());
                break;
            }
            case 20: {
                this.vertex.setY(value.getDoubleValue());
                break;
            }
            case 30: {
                this.vertex.setZ(value.getDoubleValue());
                break;
            }
            case 3: {
                this.leader.setStyleNameID(value.getValue());
                break;
            }
            case 71: {
                this.leader.setArrowEnabled(value.getBooleanValue());
                break;
            }
            case 72: {
                this.leader.setPathType(value.getIntegerValue());
                break;
            }
            case 73: {
                this.leader.setCreationType(value.getIntegerValue());
                break;
            }
            case 74: {
                this.leader.setHooklineDirecton(value.getIntegerValue());
                break;
            }
            case 75: {
                this.leader.setHookline(value.getBooleanValue());
                break;
            }
            case 40: {
                this.leader.setTextHeight(value.getDoubleValue());
                break;
            }
            case 41: {
                this.leader.setTextWidth(value.getDoubleValue());
                break;
            }
            case 211: {
                this.leader.getHorizontalDirection().setX(value.getDoubleValue());
                break;
            }
            case 221: {
                this.leader.getHorizontalDirection().setY(value.getDoubleValue());
                break;
            }
            case 231: {
                this.leader.getHorizontalDirection().setZ(value.getDoubleValue());
                break;
            }
            case 212: {
                this.leader.getLastOffsetInsertion().setX(value.getDoubleValue());
                break;
            }
            case 222: {
                this.leader.getLastOffsetInsertion().setY(value.getDoubleValue());
                break;
            }
            case 232: {
                this.leader.getLastOffsetInsertion().setZ(value.getDoubleValue());
                break;
            }
            case 213: {
                this.leader.getLastOffsetText().setX(value.getDoubleValue());
                break;
            }
            case 223: {
                this.leader.getLastOffsetText().setY(value.getDoubleValue());
                break;
            }
            case 233: {
                this.leader.getLastOffsetText().setZ(value.getDoubleValue());
                break;
            }
            case 340: {
                this.leader.setTextID(value.getValue());
                break;
            }
            case 77: {
                this.leader.setColor(value.getIntegerValue());
                break;
            }
            default: {
                super.parseCommonProperty(groupCode, value, this.leader);
            }
        }
    }

    public DXFEntity getDXFEntity() {
        return this.leader;
    }

    public void endDXFEntity() {
    }

    public boolean isFollowSequence() {
        return false;
    }
}

