/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.entities;

import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFLWPolyline;
import org.kabeja.dxf.DXFVertex;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.entities.AbstractEntityHandler;

public class DXFLWPolylineHandler
extends AbstractEntityHandler {
    public static final String ENTITY_NAME = "LWPOLYLINE";
    public static final int VERTEX_BULGE = 42;
    public static final int START_WIDTH = 40;
    public static final int END_WIDTH = 41;
    public static final int CONSTANT_WIDTH = 43;
    public static final int ELEVATION = 38;
    public static final int THICKNESS = 39;
    private DXFVertex vertex;
    private DXFLWPolyline lwpolyline;

    public void endDXFEntity() {
    }

    public DXFEntity getDXFEntity() {
        return this.lwpolyline;
    }

    public String getDXFEntityName() {
        return ENTITY_NAME;
    }

    public boolean isFollowSequence() {
        return false;
    }

    public void parseGroup(int groupCode, DXFValue value) {
        switch (groupCode) {
            case 10: {
                this.createVertex();
                this.vertex.setX(value.getDoubleValue());
                break;
            }
            case 20: {
                this.vertex.setY(value.getDoubleValue());
                break;
            }
            case 30: {
                this.vertex.setZ(value.getDoubleValue());
                break;
            }
            case 42: {
                this.vertex.setBulge(value.getDoubleValue());
                break;
            }
            case 40: {
                this.vertex.setStartWidth(value.getDoubleValue());
                break;
            }
            case 41: {
                this.vertex.setEndWidth(value.getDoubleValue());
                break;
            }
            case 43: {
                this.lwpolyline.setConstantWidth(value.getDoubleValue());
                break;
            }
            case 38: {
                this.lwpolyline.setElevation(value.getDoubleValue());
                break;
            }
            case 39: {
                this.lwpolyline.setThickness(value.getDoubleValue());
                break;
            }
            default: {
                super.parseCommonProperty(groupCode, value, this.lwpolyline);
            }
        }
    }

    public void startDXFEntity() {
        this.lwpolyline = new DXFLWPolyline();
    }

    private void createVertex() {
        this.vertex = new DXFVertex();
        this.vertex.setDXFDocument(this.doc);
        this.lwpolyline.addVertex(this.vertex);
    }
}

