/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.entities;

import org.kabeja.dxf.DXFArc;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.entities.AbstractEntityHandler;

public class DXFArcHandler
extends AbstractEntityHandler {
    public static final String ENTITY_NAME = "ARC";
    public static final int RADIUS = 40;
    public static final int START_ANGLE = 50;
    public static final int END_ANGLE = 51;
    public static final int COUNTERCLOCKWISE = 73;
    private DXFArc arc;

    public void endDXFEntity() {
    }

    public DXFEntity getDXFEntity() {
        return this.arc;
    }

    public String getDXFEntityName() {
        return ENTITY_NAME;
    }

    public boolean isFollowSequence() {
        return false;
    }

    public void parseGroup(int groupCode, DXFValue value) {
        switch (groupCode) {
            case 10: {
                this.arc.getCenterPoint().setX(value.getDoubleValue());
                break;
            }
            case 20: {
                this.arc.getCenterPoint().setY(value.getDoubleValue());
                break;
            }
            case 40: {
                this.arc.setRadius(value.getDoubleValue());
                break;
            }
            case 50: {
                this.arc.setStartAngle(value.getDoubleValue());
                break;
            }
            case 51: {
                this.arc.setEndAngle(value.getDoubleValue());
                break;
            }
            case 73: {
                this.arc.setCounterClockwise(value.getBooleanValue());
                break;
            }
            default: {
                super.parseCommonProperty(groupCode, value, this.arc);
            }
        }
    }

    public void startDXFEntity() {
        this.arc = new DXFArc();
    }
}

