/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.entities;

import org.kabeja.dxf.DXFDocument;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.entities.DXFEntityHandler;

public abstract class AbstractEntityHandler
implements DXFEntityHandler {
    public static final int ELEMENT_REFERENCE = 5;
    public static final int GROUPCODE_START_X = 10;
    public static final int GROUPCODE_START_Y = 20;
    public static final int GROUPCODE_START_Z = 30;
    public static final int END_X = 11;
    public static final int END_Y = 21;
    public static final int END_Z = 31;
    public static final int LAYER_NAME = 8;
    public static final int TRANSPARENCY = 440;
    public static final int COLOR_CODE = 62;
    public static final int COLORNAME = 430;
    public static final int COLOR_24BIT = 420;
    public static final int COLOR_TRANSPARENCY = 440;
    public static final int FLAGS = 70;
    public static final int EXTRUSION_X = 210;
    public static final int EXTRUSION_Y = 220;
    public static final int EXTRUSION_Z = 230;
    public static final int VISIBILITY = 60;
    public static final int LINE_TYPE = 6;
    public static final int LINE_TYPE_SCALE = 48;
    public static final int LINE_WEIGHT = 370;
    public static final int GROUPCODE_THICKNESS = 39;
    public static final int GROUPCODE_STYLENAME = 3;
    public static final int GROUPCODE_TEXT = 1;
    public static final int GROUPCODE_ROTATION_ANGLE = 50;
    public static final int GROUPCODE_MODELSPACE = 67;
    protected DXFDocument doc;

    public void setDXFDocument(DXFDocument doc) {
        this.doc = doc;
    }

    protected void parseCommonProperty(int groupCode, DXFValue value, DXFEntity entity) {
        switch (groupCode) {
            case 5: {
                entity.setID(value.getValue());
                break;
            }
            case 8: {
                entity.setLayerName(value.getValue());
                break;
            }
            case 70: {
                entity.setFlags(value.getIntegerValue());
                break;
            }
            case 60: {
                entity.setVisibile(!value.getBooleanValue());
                break;
            }
            case 6: {
                entity.setLineType(value.getValue());
                break;
            }
            case 48: {
                entity.setLinetypeScaleFactor(value.getDoubleValue());
                break;
            }
            case 62: {
                entity.setColor(value.getIntegerValue());
                break;
            }
            case 210: {
                entity.setExtrusionX(value.getDoubleValue());
                break;
            }
            case 220: {
                entity.setExtrusionY(value.getDoubleValue());
                break;
            }
            case 230: {
                entity.setExtrusionZ(value.getDoubleValue());
                break;
            }
            case 420: {
                break;
            }
            case 440: {
                break;
            }
            case 370: {
                entity.setLineWeight(value.getIntegerValue());
                break;
            }
            case 39: {
                entity.setThickness(value.getDoubleValue());
                break;
            }
            case 67: {
                entity.setModelSpace(value.getBooleanValue());
            }
        }
    }

    public abstract String getDXFEntityName();

    public void releaseDXFDocument() {
        this.doc = null;
    }
}

