/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.dxf.filter;

import org.kabeja.parser.DXFValue;
import org.kabeja.parser.ParseException;
import org.kabeja.parser.dxf.filter.AbstractDXFStreamFilter;

abstract class DXFStreamSectionFilter
extends AbstractDXFStreamFilter {
    private static final String SECTION_START = "SECTION";
    private static final String SECTION_END = "ENDSEC";
    private static final int COMMAND_CODE = 0;
    protected boolean sectionStarts = false;
    protected String section;

    DXFStreamSectionFilter() {
    }

    public void parseGroup(int groupCode, DXFValue value) throws ParseException {
        if (groupCode == 0 && SECTION_START.equals(value.getValue())) {
            this.sectionStarts = true;
        } else if (this.sectionStarts) {
            this.sectionStarts = false;
            this.section = value.getValue();
            this.sectionStart(this.section);
            this.parseSection(0, new DXFValue(SECTION_START));
            this.parseSection(groupCode, value);
        } else {
            this.parseSection(groupCode, value);
        }
        if (groupCode == 0 && SECTION_END.equals(value.getValue())) {
            this.sectionEnd(this.section);
        }
    }

    protected abstract void parseSection(int var1, DXFValue var2) throws ParseException;

    protected abstract void sectionStart(String var1) throws ParseException;

    protected abstract void sectionEnd(String var1) throws ParseException;
}

