/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.dxf.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.ParseException;
import org.kabeja.parser.dxf.filter.DXFStreamEntityFilter;

public class DXFStreamLayerFilter
extends DXFStreamEntityFilter {
    public static final String PROPERTY_LAYERS_EXCLUDE = "layers.exclude";
    public static final String PROPERTY_LAYERS_INCLUDE = "layers.include";
    public static final int LAYER_NAME = 8;
    protected List parseValues = new ArrayList();
    protected Set exclude = new HashSet();
    protected Set include = new HashSet();
    protected String layer = "";
    boolean findLayer = true;

    public void setProperties(Map properties) {
        StringTokenizer st;
        if (properties.containsKey(PROPERTY_LAYERS_INCLUDE)) {
            this.include.clear();
            st = new StringTokenizer((String)properties.get(PROPERTY_LAYERS_INCLUDE), "|");
            while (st.hasMoreTokens()) {
                String layer = st.nextToken();
                this.include.add(layer);
            }
        }
        if (properties.containsKey(PROPERTY_LAYERS_EXCLUDE)) {
            this.exclude.clear();
            st = new StringTokenizer((String)properties.get(PROPERTY_LAYERS_EXCLUDE), "|");
            while (st.hasMoreTokens()) {
                this.exclude.add(st.nextToken());
            }
        }
    }

    protected void endEntity() throws ParseException {
        if (this.include.contains(this.layer)) {
            this.outputEntity();
        } else if (!this.exclude.contains(this.layer)) {
            this.outputEntity();
        }
    }

    protected void outputEntity() throws ParseException {
        for (int i = 0; i < this.parseValues.size(); ++i) {
            ParseValue v = (ParseValue)this.parseValues.get(i);
            this.handler.parseGroup(v.getGroupCode(), v.getDXFValue());
        }
    }

    protected void startEntity(String type) throws ParseException {
        this.parseValues.clear();
        this.findLayer = true;
    }

    protected void parseEntity(int groupCode, DXFValue value) throws ParseException {
        if (this.findLayer && groupCode == 8) {
            this.layer = value.getValue();
            this.findLayer = false;
        }
        ParseValue v = new ParseValue(groupCode, value);
        this.parseValues.add(v);
    }

    private class ParseValue {
        int groupCode;
        DXFValue value;

        public ParseValue(int groupCode, DXFValue value) {
            this.groupCode = groupCode;
            this.value = value;
        }

        public int getGroupCode() {
            return this.groupCode;
        }

        public DXFValue getDXFValue() {
            return this.value;
        }
    }
}

