/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.dxf.filter;

import org.kabeja.parser.DXFValue;
import org.kabeja.parser.ParseException;
import org.kabeja.parser.dxf.filter.DXFStreamSectionFilter;

abstract class DXFStreamEntityFilter
extends DXFStreamSectionFilter {
    private static String SECTION_KEY = "ENTITIES";
    public static final int ENTITY_START = 0;
    protected boolean entitySection = false;
    protected boolean parseEntity = false;
    protected boolean parseHeader = false;

    DXFStreamEntityFilter() {
    }

    protected void parseSection(int groupCode, DXFValue value) throws ParseException {
        if (this.parseHeader) {
            if (value.getValue().equals(SECTION_KEY)) {
                this.entitySection = true;
                this.parseHeader = false;
            }
        } else if (this.entitySection) {
            if (groupCode == 0) {
                if (this.parseEntity) {
                    this.endEntity();
                } else {
                    this.parseEntity = true;
                }
                this.startEntity(value.getValue());
            }
            this.parseEntity(groupCode, value);
            return;
        }
        this.handler.parseGroup(groupCode, value);
    }

    protected void sectionEnd(String Section2) throws ParseException {
        if (this.section.equals(SECTION_KEY)) {
            this.entitySection = false;
        }
    }

    protected void sectionStart(String Section2) throws ParseException {
        if (this.section.equals(SECTION_KEY)) {
            this.parseHeader = true;
        }
    }

    protected abstract void startEntity(String var1) throws ParseException;

    protected abstract void endEntity() throws ParseException;

    protected abstract void parseEntity(int var1, DXFValue var2) throws ParseException;
}

