/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.math;

import org.kabeja.dxf.DXFExtrusion;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.dxf.helpers.Vector;
import org.kabeja.math.MathUtils;

public class ParametricPlane {
    protected Point base;
    protected Vector directionX;
    protected Vector directionY;
    protected Vector normal;

    public ParametricPlane(Point basePoint, Vector directionX, Vector directionY, Vector normal) {
        this.base = basePoint;
        this.directionX = directionX;
        this.directionY = directionY;
        this.normal = normal;
    }

    public ParametricPlane(Point basePoint, Vector directionX, Vector directionY) {
        this(basePoint, directionX, directionY, MathUtils.normalize(MathUtils.crossProduct(directionX, directionY)));
    }

    public ParametricPlane(Point basePoint, Point b, Vector normal) {
        this(basePoint, MathUtils.normalize(MathUtils.getVector(basePoint, b)), MathUtils.normalize(MathUtils.crossProduct(normal, MathUtils.normalize(MathUtils.getVector(basePoint, b)))), normal);
    }

    public ParametricPlane(Point basePoint, Point b, Point c) {
        this(basePoint, MathUtils.normalize(MathUtils.getVector(basePoint, b)), MathUtils.normalize(MathUtils.getVector(basePoint, c)));
    }

    public ParametricPlane(DXFExtrusion e) {
        this(new Point(0.0, 0.0, 0.0), e.getDirectionX(), e.getDirectionY(), e.getNormal());
    }

    public Point getPoint(double x, double y) {
        Point p = new Point();
        p.setX(this.base.getX() + this.directionX.getX() * x + this.directionY.getX() * y);
        p.setY(this.base.getY() + this.directionX.getY() * x + this.directionY.getY() * y);
        p.setZ(this.base.getZ() + this.directionX.getZ() * x + this.directionY.getZ() * y);
        return p;
    }

    public Point getPoint(Point point) {
        return this.getPoint(point.getX(), point.getY());
    }

    public double[] getParameter(Point p) {
        double u = 0.0;
        double v = this.directionX.getY() * this.directionY.getX() - this.directionX.getX() * this.directionY.getY();
        if (v != 0.0) {
            v = (p.getY() * this.directionY.getX() - this.base.getY() * this.directionY.getX() - this.directionY.getY() * p.getX() + this.base.getX() * this.directionY.getY()) / v;
        }
        if (this.directionY.getX() != 0.0) {
            u = (p.getX() - this.base.getX() - this.directionX.getX() * v) / this.directionY.getX();
        } else if (this.directionY.getY() != 0.0) {
            u = (p.getY() - this.base.getY() - this.directionX.getY() * v) / this.directionY.getY();
        } else if (this.directionY.getY() != 0.0) {
            u = (p.getZ() - this.base.getZ() - this.directionX.getZ() * v) / this.directionY.getZ();
        }
        return new double[]{v, u};
    }

    public boolean isOnPlane(Point p) {
        double[] para = this.getParameter(p);
        double v = this.base.getZ() + this.directionX.getZ() * para[0] + this.directionY.getZ() * para[1];
        if (!(Math.abs(p.getZ() - v) < 1.0E-5)) {
            return false;
        }
        v = this.base.getY() + this.directionX.getY() * para[0] + this.directionY.getY() * para[1];
        if (!(Math.abs(p.getY() - v) < 1.0E-5)) {
            return false;
        }
        v = this.base.getX() + this.directionX.getX() * para[0] + this.directionY.getX() * para[1];
        return Math.abs(p.getX() - v) < 1.0E-5;
    }

    public Point getBasePoint() {
        return this.base;
    }

    public void setBasePoint(Point base) {
        this.base = base;
    }

    public Vector getDirectionX() {
        return this.directionX;
    }

    public void setDirectionX(Vector directionX) {
        this.directionX = directionX;
        this.normal = MathUtils.crossProduct(this.directionX, this.directionY);
        this.normal.normalize();
    }

    public Vector getDirectionY() {
        return this.directionY;
    }

    public void setDirectionY(Vector directionY) {
        this.directionY = directionY;
        this.normal = MathUtils.crossProduct(this.directionX, this.directionY);
        this.normal.normalize();
    }

    public Vector getNormal() {
        return this.normal;
    }
}

