/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf.objects;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.kabeja.dxf.objects.DXFObject;

public class DXFDictionary
extends DXFObject {
    protected ArrayList records = new ArrayList();

    public String getObjectType() {
        return "DICTIONARY";
    }

    public boolean hasDXFObjectByID(String id) {
        return this.findByID(id) != null;
    }

    public String getNameForDXFObjectID(String id) {
        return this.findByID(id).getName();
    }

    public DXFObject getDXFObjectByID(String id) {
        DXFDictionaryRecord dicRecord;
        DXFDictionary dic = this.getDXFDictionaryForID(id);
        if (dic != null && (dicRecord = dic.findByID(id)) != null) {
            return dicRecord.getDXFObject();
        }
        return null;
    }

    public DXFObject getDXFObjectByName(String name) {
        DXFDictionaryRecord record = this.findByName(name);
        if (record != null) {
            return record.getDXFObject();
        }
        return null;
    }

    public void putDXFObject(DXFObject obj) {
        this.findByID(obj.getID()).setDXFObject(obj);
    }

    public void putDXFObjectRelation(String name, String id) {
        DXFDictionaryRecord record = null;
        record = this.findByName(name);
        if (record != null) {
            record.setID(id);
        } else {
            record = new DXFDictionaryRecord(name, id);
            this.records.add(record);
        }
    }

    protected DXFDictionaryRecord findByName(String name) {
        for (int i = 0; i < this.records.size(); ++i) {
            DXFDictionaryRecord record = (DXFDictionaryRecord)this.records.get(i);
            if (!record.getName().equals(name)) continue;
            return record;
        }
        return null;
    }

    protected DXFDictionaryRecord findByID(String id) {
        for (int i = 0; i < this.records.size(); ++i) {
            DXFDictionaryRecord record = (DXFDictionaryRecord)this.records.get(i);
            if (!record.getID().equals(id)) continue;
            return record;
        }
        return null;
    }

    public DXFDictionary getDXFDictionaryForID(String id) {
        HashSet<DXFObject> dictionaries = new HashSet<DXFObject>();
        DXFObject obj = null;
        for (int i = 0; i < this.records.size(); ++i) {
            DXFDictionaryRecord dXFDictionaryRecord = (DXFDictionaryRecord)this.records.get(i);
            if (dXFDictionaryRecord.getID().equals(id)) {
                return this;
            }
            obj = dXFDictionaryRecord.getDXFObject();
            if (obj == null || !obj.getObjectType().equals("DICTIONARY")) continue;
            dictionaries.add(obj);
        }
        for (DXFDictionary dXFDictionary : dictionaries) {
            DXFDictionary d = dXFDictionary.getDXFDictionaryForID(id);
            if (d == null) continue;
            return d;
        }
        return null;
    }

    public Iterator getDXFObjectIterator() {
        Iterator i = new Iterator(){
            int count = 0;

            public boolean hasNext() {
                return this.count < DXFDictionary.this.records.size();
            }

            public Object next() {
                return ((DXFDictionaryRecord)DXFDictionary.this.records.get(this.count++)).getDXFObject();
            }

            public void remove() {
                DXFDictionary.this.records.remove(this.count - 1);
            }
        };
        return i;
    }

    private class DXFDictionaryRecord {
        private String id;
        private String name;
        private DXFObject obj;

        public DXFDictionaryRecord(String name, String id) {
            this.id = id;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getID() {
            return this.id;
        }

        public void setID(String id) {
            this.id = id;
        }

        public void setDXFObject(DXFObject obj) {
            this.obj = obj;
        }

        public DXFObject getDXFObject() {
            return this.obj;
        }
    }
}

