/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf.helpers;

import org.kabeja.dxf.helpers.Point;

public class HatchLineFamily {
    private double rotationAngle;
    private double baseX;
    private double baseY;
    private double offsetX;
    private double offsetY;
    private double length = 0.0;
    private double[] pattern = new double[0];

    public double getBaseX() {
        return this.baseX;
    }

    public void setBaseX(double baseX) {
        this.baseX = baseX;
    }

    public double getBaseY() {
        return this.baseY;
    }

    public void setBaseY(double baseY) {
        this.baseY = baseY;
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(double offsetX) {
        this.offsetX = offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(double offsetY) {
        this.offsetY = offsetY;
    }

    public double[] getPattern() {
        return this.pattern;
    }

    public void setPattern(double[] pattern) {
        if (pattern != null) {
            this.pattern = pattern;
        }
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    public void setRotationAngle(double rotationAngle) {
        this.rotationAngle = rotationAngle;
    }

    public double getLength() {
        if (this.length <= 0.0) {
            for (int i = 0; i < this.pattern.length; ++i) {
                this.length += Math.abs(this.pattern[i]);
            }
        }
        return this.length;
    }

    public double getPatternWidth() {
        return this.getLength() * Math.cos(this.rotationAngle);
    }

    public double getPatternHeight() {
        return this.getLength() * Math.sin(this.rotationAngle);
    }

    public Point getBasePoint() {
        return this.transform(this.baseX, this.baseY);
    }

    public Point getOffsetPoint() {
        return this.transform(this.offsetX, this.offsetY);
    }

    protected Point transform(double x, double y) {
        Point p = new Point();
        p.setX(Math.cos(this.rotationAngle) * x + Math.sin(this.rotationAngle) * y);
        p.setY(Math.cos(this.rotationAngle) * y - Math.sin(this.rotationAngle) * x);
        return p;
    }

    public Point getMinimalBasePoint() {
        Point p = new Point();
        Point b = this.getBasePoint();
        Point o = this.getOffsetPoint();
        p.setX(b.getX() % o.getX());
        p.setY(b.getY() % o.getY());
        return p;
    }
}

