/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf.helpers;

import java.util.Stack;
import java.util.StringTokenizer;
import org.kabeja.dxf.DXFMText;
import org.kabeja.dxf.DXFText;
import org.kabeja.dxf.helpers.DXFUtils;
import org.kabeja.dxf.helpers.StyledTextParagraph;
import org.kabeja.dxf.helpers.TextDocument;

public class DXFTextParser {
    public static TextDocument parseDXFMText(DXFMText text) {
        TextDocument doc = new TextDocument();
        StringBuilder buf = new StringBuilder();
        StringBuilder value = new StringBuilder();
        StyledTextParagraph p = new StyledTextParagraph();
        p.setFontHeight(text.getHeight());
        p.setInsertPoint(text.getInsertPoint());
        switch (text.getAlignment()) {
            case 1: {
                p.setValign(2);
                break;
            }
            case 2: {
                p.setValign(2);
                break;
            }
            case 3: {
                p.setValign(2);
                break;
            }
            case 4: {
                p.setValign(4);
                break;
            }
            case 5: {
                p.setValign(4);
                break;
            }
            case 6: {
                p.setValign(4);
                break;
            }
            case 7: {
                p.setValign(1);
                break;
            }
            case 8: {
                p.setValign(1);
                break;
            }
            case 9: {
                p.setValign(1);
                break;
            }
            default: {
                p.setValign(1);
            }
        }
        boolean formatting = false;
        boolean keyfollow = false;
        boolean complete = true;
        Stack<StyledTextParagraph> paras = new Stack<StyledTextParagraph>();
        int linecount = 0;
        String str = text.getText();
        char key = ' ';
        str = DXFTextParser.parseSymbols(str);
        block24: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\\': {
                    if (formatting) {
                        if (!complete) {
                            DXFTextParser.parseStyledTextParagraphSettings(key, value.toString(), p);
                            value.delete(0, value.length());
                            formatting = true;
                            keyfollow = true;
                            continue block24;
                        }
                        buf.append(c);
                        formatting = false;
                        continue block24;
                    }
                    formatting = true;
                    keyfollow = true;
                    complete = false;
                    continue block24;
                }
                case '~': {
                    if (!formatting) continue block24;
                    buf.append(c);
                    formatting = false;
                    keyfollow = false;
                    continue block24;
                }
                case ';': {
                    if (formatting) {
                        DXFTextParser.parseStyledTextParagraphSettings(key, value.toString(), p);
                        value.delete(0, value.length());
                        formatting = false;
                        complete = true;
                        keyfollow = false;
                        continue block24;
                    }
                    buf.append(c);
                    continue block24;
                }
                case '}': {
                    if (formatting && keyfollow) {
                        buf.append(c);
                        formatting = false;
                        keyfollow = false;
                        continue block24;
                    }
                    if (formatting) {
                        value.append(c);
                        continue block24;
                    }
                    doc.addStyledParagraph(p);
                    p = DXFTextParser.createParagraphFromParent(p);
                    if (paras.size() <= 0) continue block24;
                    p = (StyledTextParagraph)paras.pop();
                    continue block24;
                }
                case '{': {
                    if (formatting && keyfollow) {
                        buf.append(c);
                        formatting = false;
                        keyfollow = false;
                        continue block24;
                    }
                    if (formatting) {
                        value.append(c);
                        continue block24;
                    }
                    if (i == 0) continue block24;
                    paras.add(p);
                    p = new StyledTextParagraph();
                    continue block24;
                }
                case 'O': {
                    if (formatting && keyfollow) {
                        p.setText(buf.toString());
                        buf.delete(0, buf.length());
                        doc.addStyledParagraph(p);
                        p = DXFTextParser.createParagraphFromParent(p);
                        p.setOverline(true);
                        formatting = false;
                        keyfollow = false;
                        continue block24;
                    }
                    if (formatting) {
                        value.append(c);
                        continue block24;
                    }
                    buf.append(c);
                    continue block24;
                }
                case 'o': {
                    if (formatting && keyfollow) {
                        p.setText(buf.toString());
                        buf.delete(0, buf.length());
                        doc.addStyledParagraph(p);
                        p = DXFTextParser.createParagraphFromParent(p);
                        p.setOverline(false);
                        formatting = false;
                        keyfollow = false;
                        continue block24;
                    }
                    if (formatting) {
                        value.append(c);
                        continue block24;
                    }
                    buf.append(c);
                    continue block24;
                }
                case 'u': {
                    if (formatting && keyfollow) {
                        p.setText(buf.toString());
                        buf.delete(0, buf.length());
                        doc.addStyledParagraph(p);
                        p = DXFTextParser.createParagraphFromParent(p);
                        p.setUnderline(false);
                        formatting = false;
                        keyfollow = false;
                        continue block24;
                    }
                    if (formatting) {
                        value.append(c);
                        continue block24;
                    }
                    buf.append(c);
                    continue block24;
                }
                case 'L': {
                    if (formatting && keyfollow) {
                        p.setText(buf.toString());
                        buf.delete(0, buf.length());
                        doc.addStyledParagraph(p);
                        p = DXFTextParser.createParagraphFromParent(p);
                        p.setUnderline(true);
                        formatting = false;
                        keyfollow = false;
                        continue block24;
                    }
                    if (formatting) {
                        value.append(c);
                        continue block24;
                    }
                    buf.append(c);
                    continue block24;
                }
                case 'l': {
                    if (formatting && keyfollow) {
                        p.setText(buf.toString());
                        buf.delete(0, buf.length());
                        doc.addStyledParagraph(p);
                        p = DXFTextParser.createParagraphFromParent(p);
                        p.setUnderline(false);
                        formatting = false;
                        keyfollow = false;
                        continue block24;
                    }
                    if (formatting) {
                        value.append(c);
                        continue block24;
                    }
                    buf.append(c);
                    continue block24;
                }
                case 'P': {
                    if (formatting && keyfollow) {
                        ++linecount;
                        p.setText(buf.toString());
                        buf.delete(0, buf.length());
                        doc.addStyledParagraph(p);
                        p = DXFTextParser.createParagraphFromParent(p);
                        formatting = false;
                        keyfollow = false;
                        p.setLineIndex(linecount);
                        p.setNewline(true);
                        continue block24;
                    }
                    if (formatting) {
                        value.append(c);
                        continue block24;
                    }
                    buf.append(c);
                    continue block24;
                }
                default: {
                    if (formatting) {
                        if (keyfollow) {
                            key = c;
                            keyfollow = false;
                            continue block24;
                        }
                        value.append(c);
                        continue block24;
                    }
                    buf.append(c);
                }
            }
        }
        if (formatting) {
            DXFTextParser.parseStyledTextParagraphSettings(key, value.toString(), p);
        }
        if (buf.length() > 0) {
            p.setText(buf.toString());
            doc.addStyledParagraph(p);
        }
        if (doc.getParagraphCount() == 0) {
            doc.addStyledParagraph(p);
        }
        return doc;
    }

    protected static StyledTextParagraph createParagraphFromParent(StyledTextParagraph parent) {
        StyledTextParagraph p = new StyledTextParagraph();
        p.setValign(parent.getValign());
        p.setBold(parent.isBold());
        p.setFont(parent.getFont());
        p.setItalic(parent.isItalic());
        p.setUnderline(parent.isUnderline());
        p.setOverline(parent.isOverline());
        p.setWidth(parent.getWidth());
        p.setFontHeight(parent.getFontHeight());
        p.setInsertPoint(parent.getInsertPoint());
        return p;
    }

    public static TextDocument parseDXFText(DXFText text) {
        TextDocument doc = new TextDocument();
        StringBuilder buf = new StringBuilder();
        StyledTextParagraph p = new StyledTextParagraph();
        p.setFontHeight(text.getHeight());
        p.setInsertPoint(text.getAlignmentPoint());
        switch (text.getValign()) {
            case 0: {
                if (text.getAlign() == 4) {
                    p.setValign(4);
                    break;
                }
                p.setValign(1);
                break;
            }
            case 1: {
                p.setValign(1);
                break;
            }
            case 2: {
                p.setValign(4);
                break;
            }
            case 3: {
                p.setValign(2);
            }
        }
        if (text.getAlign() == 3 || text.getAlign() == 5) {
            double length = DXFUtils.distance(text.getInsertPoint(), text.getAlignmentPoint());
            p.setWidth(length);
        }
        String str = DXFTextParser.parseSymbols(text.getText());
        int marker = 0;
        boolean overline = false;
        boolean underline = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '%') {
                ++marker;
                continue;
            }
            if (marker == 0) {
                buf.append(c);
                continue;
            }
            if (marker != 2) continue;
            switch (c) {
                case 'o': {
                    p.setText(buf.toString());
                    p.setUnderline(underline);
                    p.setOverline(overline);
                    doc.addStyledParagraph(p);
                    p = DXFTextParser.createParagraphFromParent(p);
                    buf.delete(0, buf.length());
                    overline = !overline;
                    p.setOverline(overline);
                    break;
                }
                case 'u': {
                    p.setText(buf.toString());
                    p.setUnderline(underline);
                    p.setOverline(overline);
                    doc.addStyledParagraph(p);
                    p = DXFTextParser.createParagraphFromParent(p);
                    buf.delete(0, buf.length());
                    underline = !underline;
                    p.setUnderline(underline);
                }
            }
            marker = 0;
        }
        if (marker == 1 || marker == 3) {
            buf.append('%');
        }
        if (buf.length() > 0) {
            p.setText(buf.toString());
            doc.addStyledParagraph(p);
        }
        return doc;
    }

    public static void parseStyledTextParagraphSettings(char key, String value, StyledTextParagraph para) {
        switch (key) {
            case 'A': {
                para.setValign(Integer.parseInt(value));
                break;
            }
            case 'H': {
                if (value.toLowerCase().endsWith("x")) {
                    para.setFontHeight(para.getFontHeight() * Double.parseDouble(value.substring(0, value.length() - 1)));
                    break;
                }
                para.setFontHeight(Double.parseDouble(value));
                break;
            }
            case 'Q': {
                para.setObliquiAngle(Double.parseDouble(value));
                break;
            }
            case 'W': {
                if (value.toLowerCase().endsWith("x")) {
                    para.setWidth(para.getWidth() * Double.parseDouble(value.substring(0, value.length() - 1)));
                    break;
                }
                para.setWidth(Double.parseDouble(value));
                break;
            }
            case 'T': {
                para.setCharacterspace(Double.parseDouble(value));
                break;
            }
            case 'f': {
                DXFTextParser.parseFontSettings(value.trim(), para);
                break;
            }
            case 'F': {
                para.setFontFile(value.trim());
                break;
            }
        }
    }

    public static void parseFontSettings(String value, StyledTextParagraph para) {
        StringTokenizer st = new StringTokenizer(value, "|");
        para.setFont(st.nextToken());
        while (st.hasMoreTokens()) {
            String option = st.nextToken();
            char code = option.charAt(0);
            int i = Integer.parseInt(option.substring(1));
            switch (code) {
                case 'b': {
                    para.setBold(i == 1);
                    break;
                }
                case 'i': {
                    para.setItalic(i == 1);
                    break;
                }
                case 'c': {
                    break;
                }
            }
        }
    }

    public static String parseSymbols(String text) {
        boolean asciicontrol = false;
        StringBuilder buf = new StringBuilder();
        int marker = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '%') {
                if (marker == 2) {
                    buf.append('%');
                    marker = 0;
                    continue;
                }
                ++marker;
                continue;
            }
            if (c == '^') {
                asciicontrol = true;
                continue;
            }
            if (asciicontrol) {
                if (Character.isWhitespace(c)) {
                    buf.append('^');
                }
                asciicontrol = false;
                continue;
            }
            if (c == '\\') {
                if (text.length() > i + 6 && text.charAt(i + 1) == 'U' && text.charAt(i + 2) == '+') {
                    String part = text.substring(i + 3, i + 7);
                    int unicode = Integer.parseInt(part, 16);
                    buf.append((char)unicode);
                    i += 6;
                    continue;
                }
                buf.append('\\');
                continue;
            }
            if (marker == 0) {
                buf.append(c);
                continue;
            }
            if (marker == 1) {
                buf.append('%');
                marker = 0;
                continue;
            }
            if (marker == 2) {
                switch (c) {
                    case 'd': {
                        buf.append('\u00b0');
                        break;
                    }
                    case 'c': {
                        buf.append('\u2205');
                        break;
                    }
                    case 'p': {
                        buf.append('\u00b1');
                        break;
                    }
                    default: {
                        if (Character.isDigit(c) && i + 2 < text.length()) {
                            String code = "" + c + text.charAt(i + 1) + text.charAt(i + 2);
                            try {
                                c = (char)Integer.parseInt(code);
                                buf.append(c);
                                i += 2;
                            }
                            catch (NumberFormatException e) {
                                buf.append('?');
                                ++i;
                            }
                            break;
                        }
                        buf.append("%%");
                        buf.append(c);
                    }
                }
                marker = 0;
                continue;
            }
            if (marker != 3) continue;
            buf.append('%');
            marker = 0;
        }
        if (marker == 1 || marker == 3) {
            buf.append('%');
        }
        return buf.toString();
    }
}

