/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf.helpers;

import java.util.ArrayList;
import java.util.Iterator;
import org.kabeja.dxf.DXFPolyline;
import org.kabeja.dxf.DXFSpline;
import org.kabeja.dxf.DXFVertex;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.dxf.helpers.SplinePoint;
import org.kabeja.math.NURBS;
import org.kabeja.math.NURBSFixedNTELSPointIterator;

public class DXFSplineConverter {
    public static DXFPolyline toDXFPolyline(DXFSpline spline) {
        DXFPolyline p = new DXFPolyline();
        p.setDXFDocument(spline.getDXFDocument());
        if (spline.getDegree() > 0 && spline.getKnots().length > 0) {
            NURBSFixedNTELSPointIterator pi = new NURBSFixedNTELSPointIterator(DXFSplineConverter.toNurbs(spline), 30);
            while (pi.hasNext()) {
                p.addVertex(new DXFVertex((Point)pi.next()));
            }
        } else {
            Iterator i = spline.getSplinePointIterator();
            while (i.hasNext()) {
                SplinePoint sp = (SplinePoint)i.next();
                if (!sp.isControlPoint()) continue;
                p.addVertex(new DXFVertex(sp));
            }
        }
        if (spline.isClosed()) {
            p.setFlags(1);
        }
        return p;
    }

    public static NURBS toNurbs(DXFSpline spline) {
        Iterator i = spline.getSplinePointIterator();
        ArrayList<SplinePoint> list = new ArrayList<SplinePoint>();
        while (i.hasNext()) {
            SplinePoint sp = (SplinePoint)i.next();
            if (!sp.isControlPoint()) continue;
            list.add(sp);
        }
        NURBS n = new NURBS(list.toArray(new Point[list.size()]), spline.getKnots(), spline.getWeights(), spline.getDegree());
        n.setClosed(spline.isClosed());
        return n;
    }
}

