/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFPolyline;
import org.kabeja.dxf.helpers.DXFSplineConverter;
import org.kabeja.dxf.helpers.SplinePoint;

public class DXFSpline
extends DXFEntity {
    protected static final int APPROXIMATION_STEPS = 10;
    protected int degree;
    protected int nodePointsSize;
    protected int controlPointSize;
    protected int fitPointSize;
    protected double[] knots;
    protected double[] weights;
    protected List points = new ArrayList();
    protected double fitTolerance;
    protected double knotsTolerance;
    protected double controlPointTolerance;
    DXFPolyline polyline;

    public Bounds getBounds() {
        if (this.polyline == null) {
            this.polyline = this.toDXFPolyline();
        }
        return this.polyline.getBounds();
    }

    public String getType() {
        return "SPLINE";
    }

    public void addSplinePoint(SplinePoint p) {
        this.points.add(p);
        this.polyline = null;
    }

    public Iterator getSplinePointIterator() {
        return this.points.iterator();
    }

    public boolean isRational() {
        return (this.flags & 4) == 4;
    }

    public boolean isClosed() {
        return (this.flags & 1) == 1;
    }

    public boolean isPeriodic() {
        return (this.flags & 2) == 2;
    }

    public boolean isPlanar() {
        return (this.flags & 8) == 8;
    }

    public boolean isLinear() {
        return (this.flags & 0x10) == 16;
    }

    public int getControlPointSize() {
        return this.controlPointSize;
    }

    public void setControlPointSize(int controlPointSize) {
        this.controlPointSize = controlPointSize;
    }

    public int getDegree() {
        return this.degree;
    }

    public void setDegree(int degree) {
        this.degree = degree;
    }

    public int getFitPointSize() {
        return this.fitPointSize;
    }

    public void setFitPointSize(int fitPointSize) {
        this.fitPointSize = fitPointSize;
    }

    public double getFitTolerance() {
        return this.fitTolerance;
    }

    public void setFitTolerance(double fitTolerance) {
        this.fitTolerance = fitTolerance;
    }

    public double[] getKnots() {
        return this.knots;
    }

    public void setKnots(double[] knots) {
        this.knots = knots;
        this.polyline = null;
    }

    public int getNodePointsSize() {
        return this.nodePointsSize;
    }

    public void setNodePointsSize(int nodePointsSize) {
        this.nodePointsSize = nodePointsSize;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public void setWeights(double[] weights) {
        this.weights = weights;
    }

    public double getControlPointTolerance() {
        return this.controlPointTolerance;
    }

    public void setControlPointTolerance(double controlPointTolerance) {
        this.controlPointTolerance = controlPointTolerance;
    }

    public double getKnotsTolerance() {
        return this.knotsTolerance;
    }

    public void setKnotsTolerance(double knotsTolerance) {
        this.knotsTolerance = knotsTolerance;
    }

    public double getLength() {
        if (this.polyline == null) {
            this.polyline = this.toDXFPolyline();
        }
        return this.polyline.getLength();
    }

    protected DXFPolyline toDXFPolyline() {
        return DXFSplineConverter.toDXFPolyline(this);
    }
}

