/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import java.util.ArrayList;
import java.util.Iterator;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFPoint;
import org.kabeja.dxf.DXFVertex;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.dxf.helpers.Vector;
import org.kabeja.math.MathUtils;

public class DXFPolyline
extends DXFEntity {
    protected static final double QUARTER_CIRCLE_ANGLE = Math.tan(0.39269908169872414);
    protected ArrayList vertices = new ArrayList();
    protected double startWidth = 0.0;
    protected double endWidth = 0.0;
    protected boolean constantWidth = true;
    protected int surefaceType = 0;
    protected int surefaceDensityRows = 0;
    protected int surefaceDensityColumns = 0;
    protected int rows = 0;
    protected int columns = 0;

    public Bounds getBounds() {
        Bounds bounds = new Bounds();
        Iterator i = this.vertices.iterator();
        if (i.hasNext()) {
            DXFVertex first;
            DXFVertex v = null;
            DXFVertex last = first = (DXFVertex)i.next();
            bounds.addToBounds(last.getPoint());
            while (i.hasNext()) {
                v = (DXFVertex)i.next();
                this.addToBounds(last, v, bounds);
                last = v;
            }
            if (v != null && v.getBulge() != 0.0) {
                this.addToBounds(v, first, bounds);
            }
        } else {
            bounds.setValid(false);
        }
        return bounds;
    }

    public void addVertex(DXFVertex vertex) {
        this.vertices.add(vertex);
        if (!vertex.isConstantWidth()) {
            this.constantWidth = false;
        }
    }

    public int getVertexCount() {
        return this.vertices.size();
    }

    public Iterator getVertexIterator() {
        return this.vertices.iterator();
    }

    public void removeVertex(DXFVertex vertex) {
        this.constantWidth = true;
        Iterator i = this.vertices.iterator();
        while (i.hasNext()) {
            DXFVertex v = (DXFVertex)i.next();
            if (v == vertex) {
                i.remove();
                continue;
            }
            if (v.isConstantWidth()) continue;
            this.constantWidth = false;
        }
    }

    public void removeVertex(int index) {
        this.constantWidth = true;
        for (int i = 0; i < this.vertices.size(); ++i) {
            DXFVertex v = (DXFVertex)this.vertices.get(i);
            if (index == i) {
                this.vertices.remove(i);
                continue;
            }
            if (v.isConstantWidth()) continue;
            this.constantWidth = false;
        }
    }

    public DXFVertex getVertex(int i) {
        return (DXFVertex)this.vertices.get(i);
    }

    protected double getLength(DXFPoint start, DXFPoint end) {
        double value = Math.sqrt(Math.pow(end.getX() - start.getX(), 2.0) + Math.pow(end.getY() - start.getY(), 2.0));
        return value;
    }

    public double getRadius(double bulge, double length) {
        double h = bulge * length / 2.0;
        double value = h / 2.0 + Math.pow(length, 2.0) / (8.0 * h);
        return Math.abs(value);
    }

    public String getType() {
        return "POLYLINE";
    }

    public double getEndWidth() {
        return this.endWidth;
    }

    public void setEndWidth(double endWidth) {
        this.endWidth = endWidth;
    }

    public double getStartWidth() {
        return this.startWidth;
    }

    public void setStartWidth(double startWidth) {
        this.startWidth = startWidth;
    }

    public boolean isClosed() {
        return (this.flags & 1) == 1;
    }

    public boolean isCurveFitVerticesAdded() {
        return (this.flags & 2) == 2;
    }

    public boolean isSplineFitVerticesAdded() {
        return (this.flags & 4) == 4;
    }

    public boolean is3DPolygon() {
        return (this.flags & 8) == 8;
    }

    public boolean is3DPolygonMesh() {
        return (this.flags & 0x10) == 16;
    }

    public boolean isPolyfaceMesh() {
        return (this.flags & 0x40) == 64;
    }

    public boolean isClosedMeshNDirection() {
        return (this.flags & 0x20) == 32;
    }

    public boolean isClosedMeshMDirection() {
        return (this.flags & 1) == 1;
    }

    public boolean isQuadSpline() {
        if (this.isSplineFitVerticesAdded()) {
            return this.surefaceType == 5;
        }
        return false;
    }

    public boolean isCubicSpline() {
        if (this.isSplineFitVerticesAdded()) {
            return this.surefaceType == 6;
        }
        return false;
    }

    public boolean isConstantWidth() {
        if (!this.constantWidth) {
            return false;
        }
        this.constantWidth = true;
        for (DXFVertex vertex : this.vertices) {
            if (vertex.isConstantWidth()) continue;
            this.constantWidth = false;
            return this.constantWidth;
        }
        return this.constantWidth;
    }

    public int getSurefaceType() {
        return this.surefaceType;
    }

    public void setSurefaceType(int surefaceType) {
        this.surefaceType = surefaceType;
    }

    public int getSurefaceDensityColumns() {
        return this.surefaceDensityColumns;
    }

    public void setSurefaceDensityColumns(int columns) {
        this.surefaceDensityColumns = columns;
    }

    public int getSurefaceDensityRows() {
        return this.surefaceDensityRows;
    }

    public void setSurefaceDensityRows(int rows) {
        this.surefaceDensityRows = rows;
    }

    protected void addToBounds(DXFVertex start, DXFVertex end, Bounds bounds) {
        if (start.getBulge() != 0.0) {
            double t;
            double l = MathUtils.distance(start.getPoint(), end.getPoint());
            double r = this.getRadius(start.getBulge(), l);
            double s = l / 2.0;
            Vector edgeDirection = MathUtils.getVector(start.getPoint(), end.getPoint());
            edgeDirection = MathUtils.normalize(edgeDirection);
            Point centerPoint = MathUtils.getPointOfStraightLine(start.getPoint(), edgeDirection, s);
            Vector centerPointDirection = MathUtils.crossProduct(edgeDirection, this.getExtrusion().getNormal());
            centerPointDirection = MathUtils.normalize(centerPointDirection);
            double h = Math.abs(start.getBulge() * l) / 2.0;
            int startQ = 0;
            int endQ = 0;
            double bulge = start.getBulge();
            if (bulge > 0.0) {
                if (bulge > 1.0) {
                    t = h - r;
                    centerPoint = MathUtils.getPointOfStraightLine(centerPoint, centerPointDirection, t);
                } else {
                    t = r - h;
                    centerPoint = MathUtils.getPointOfStraightLine(centerPoint, centerPointDirection, -1.0 * t);
                }
                endQ = MathUtils.getQuadrant(end.getPoint(), centerPoint);
                startQ = MathUtils.getQuadrant(start.getPoint(), centerPoint);
            } else {
                if (bulge < -1.0) {
                    t = h - r;
                    centerPoint = MathUtils.getPointOfStraightLine(centerPoint, centerPointDirection, -1.0 * t);
                } else {
                    t = r - h;
                    centerPoint = MathUtils.getPointOfStraightLine(centerPoint, centerPointDirection, t);
                }
                startQ = MathUtils.getQuadrant(end.getPoint(), centerPoint);
                endQ = MathUtils.getQuadrant(start.getPoint(), centerPoint);
            }
            if (endQ < startQ) {
                endQ += 4;
            } else if (endQ == startQ && Math.abs(start.getBulge()) > QUARTER_CIRCLE_ANGLE) {
                endQ += 4;
            }
            while (endQ > startQ) {
                switch (startQ) {
                    case 0: {
                        bounds.addToBounds(centerPoint.getX(), centerPoint.getY() + r, centerPoint.getZ());
                        break;
                    }
                    case 1: {
                        bounds.addToBounds(centerPoint.getX() - r, centerPoint.getY(), centerPoint.getZ());
                        break;
                    }
                    case 2: {
                        bounds.addToBounds(centerPoint.getX(), centerPoint.getY() - r, centerPoint.getZ());
                        break;
                    }
                    case 3: {
                        bounds.addToBounds(centerPoint.getX() + r, centerPoint.getY(), centerPoint.getZ());
                        endQ -= 4;
                        startQ -= 4;
                    }
                }
                ++startQ;
            }
        }
        bounds.addToBounds(start.getPoint());
        bounds.addToBounds(end.getPoint());
    }

    public DXFVertex getPolyFaceMeshVertex(int index) {
        Iterator i = this.vertices.iterator();
        int count = 1;
        while (i.hasNext()) {
            DXFVertex v = (DXFVertex)i.next();
            if (!v.isPolyFaceMeshVertex()) continue;
            if (count == index) {
                return v;
            }
            ++count;
        }
        return null;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int column) {
        this.columns = column;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public boolean isSimpleMesh() {
        return this.surefaceType == 0 && (this.flags & 4) == 0;
    }

    public boolean isQuadSurefaceMesh() {
        return this.surefaceType == 5 && (this.flags & 4) == 4;
    }

    public boolean isCubicSurefaceMesh() {
        return this.surefaceType == 6 && (this.flags & 4) == 4;
    }

    public boolean isBezierSurefaceMesh() {
        return this.surefaceType == 8 && (this.flags & 4) == 4;
    }

    public double getLength() {
        DXFVertex first;
        double length = 0.0;
        if (this.isCubicSpline() || this.isQuadSpline()) {
            return this.getSplineApproximationLength();
        }
        if (this.isPolyfaceMesh()) {
            return this.getPolyfaceLength();
        }
        if (this.is3DPolygonMesh() || this.isBezierSurefaceMesh() || this.isCubicSurefaceMesh()) {
            return this.getMeshLength();
        }
        Iterator i = this.vertices.iterator();
        DXFVertex last = first = (DXFVertex)i.next();
        while (i.hasNext()) {
            DXFVertex v = (DXFVertex)i.next();
            length += this.getSegmentLength(last, v);
            last = v;
        }
        if (this.isClosed()) {
            length += this.getSegmentLength(last, first);
        }
        return length;
    }

    protected double getSegmentLength(DXFVertex start, DXFVertex end) {
        double l = MathUtils.distance(start.getPoint(), end.getPoint());
        if (start.getBulge() == 0.0) {
            return l;
        }
        double alpha = 4.0 * Math.atan(Math.abs(start.getBulge()));
        double r = l / (2.0 * Math.sin(alpha / 2.0));
        double d = Math.PI * Math.toDegrees(alpha) * r / 180.0;
        return d;
    }

    protected double getSplineApproximationLength() {
        double length = 0.0;
        Iterator i = this.vertices.iterator();
        DXFVertex first = null;
        DXFVertex last = null;
        while (i.hasNext()) {
            DXFVertex v = (DXFVertex)i.next();
            if (!v.is2DSplineApproximationVertex()) continue;
            if (first == null) {
                first = last = v;
                continue;
            }
            length += this.getSegmentLength(last, v);
            last = v;
        }
        if (this.isClosed()) {
            length += this.getSegmentLength(last, first);
        }
        return length;
    }

    protected double getPolyfaceLength() {
        double length = 0.0;
        for (DXFVertex v : this.vertices) {
            if (!v.isFaceRecord()) continue;
            DXFVertex v1 = this.getPolyFaceMeshVertex(v.getPolyFaceMeshVertex0());
            DXFVertex v2 = this.getPolyFaceMeshVertex(v.getPolyFaceMeshVertex1());
            DXFVertex v3 = this.getPolyFaceMeshVertex(v.getPolyFaceMeshVertex2());
            DXFVertex v4 = this.getPolyFaceMeshVertex(v.getPolyFaceMeshVertex3());
            if (v.isPolyFaceEdge0Visible() && v.getPolyFaceMeshVertex0() != 0) {
                length += this.getSegmentLength(v1, v2);
            }
            if (v.isPolyFaceEdge1Visible() && v.getPolyFaceMeshVertex1() != 0) {
                length += this.getSegmentLength(v2, v3);
            }
            if (v.isPolyFaceEdge2Visible() && v.getPolyFaceMeshVertex2() != 0) {
                length += this.getSegmentLength(v3, v4);
            }
            if (v.isPolyFaceEdge3Visible() && v.getPolyFaceMeshVertex3() != 0) {
                length += this.getSegmentLength(v4, v1);
                continue;
            }
            if (v4 != null || v3 == null) continue;
            length += this.getSegmentLength(v3, v1);
        }
        return length;
    }

    protected double getMeshLength() {
        double length = 0.0;
        if (this.isSimpleMesh()) {
            int x;
            int i;
            DXFVertex[][] points = new DXFVertex[this.rows][this.columns];
            Iterator it = this.vertices.iterator();
            for (i = 0; i < this.rows; ++i) {
                for (x = 0; x < this.columns; ++x) {
                    DXFVertex v;
                    points[i][x] = v = (DXFVertex)it.next();
                    if (x <= 0) continue;
                    length += this.getSegmentLength(points[i][x - 1], points[i][x]);
                }
                if (!this.isClosedMeshNDirection()) continue;
                length += this.getSegmentLength(points[i][points[i].length - 1], points[i][0]);
            }
            for (i = 0; i < this.columns; ++i) {
                for (x = 0; x < this.rows; ++x) {
                    if (x <= 0) continue;
                    length += this.getSegmentLength(points[x - 1][i], points[x][i]);
                }
                if (!this.isClosedMeshMDirection()) continue;
                length += this.getSegmentLength(points[points[i].length - 1][i], points[0][i]);
            }
        } else {
            int x;
            int i;
            DXFVertex[][] points = new DXFVertex[this.surefaceDensityRows][this.surefaceDensityColumns];
            Iterator vi = this.vertices.iterator();
            ArrayList<DXFVertex> appVertices = new ArrayList<DXFVertex>();
            while (vi.hasNext()) {
                DXFVertex v = (DXFVertex)vi.next();
                if (!v.isMeshApproximationVertex()) continue;
                appVertices.add(v);
            }
            Iterator it = appVertices.iterator();
            for (i = 0; i < this.surefaceDensityRows; ++i) {
                for (x = 0; x < this.surefaceDensityColumns; ++x) {
                    DXFVertex v;
                    points[i][x] = v = (DXFVertex)it.next();
                    if (x <= 0) continue;
                    length += this.getSegmentLength(points[i][x - 1], points[i][x]);
                }
                if (!this.isClosedMeshNDirection()) continue;
                length += this.getSegmentLength(points[i][points[i].length - 1], points[i][0]);
            }
            for (i = 0; i < this.surefaceDensityColumns; ++i) {
                for (x = 0; x < this.surefaceDensityRows; ++x) {
                    if (x <= 0) continue;
                    length += this.getSegmentLength(points[x - 1][i], points[x][i]);
                }
                if (!this.isClosedMeshMDirection()) continue;
                length += this.getSegmentLength(points[points[i].length - 1][i], points[0][i]);
            }
        }
        return length;
    }
}

