/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.dxf.DXFEntity;

public class DXFLayer {
    private Hashtable entities = new Hashtable();
    private String name = "";
    private int color = 0;
    private DXFDocument doc;
    private String ltype = "";
    private int flags = 0;
    private int lineWeight = 0;
    private String plotStyle = "";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addDXFEntity(DXFEntity entity) {
        entity.setDXFDocument(this.doc);
        if (this.entities.containsKey(entity.getType())) {
            ((ArrayList)this.entities.get(entity.getType())).add(entity);
        } else {
            ArrayList<DXFEntity> list = new ArrayList<DXFEntity>();
            list.add(entity);
            this.entities.put(entity.getType(), list);
        }
    }

    public void removeDXFEntity(DXFEntity entity) {
        if (this.entities.containsKey(entity.getType())) {
            ArrayList list = (ArrayList)this.entities.get(entity.getType());
            list.remove(entity);
            if (list.isEmpty()) {
                this.entities.remove(entity.getType());
            }
        }
    }

    public void setDXFDocument(DXFDocument doc) {
        this.doc = doc;
    }

    public DXFDocument getDXFDocument() {
        return this.doc;
    }

    public Bounds getBounds() {
        Bounds bounds = new Bounds();
        Enumeration e = this.entities.elements();
        while (e.hasMoreElements()) {
            ArrayList list = (ArrayList)e.nextElement();
            for (DXFEntity entity : list) {
                Bounds b = entity.getBounds();
                if (!b.isValid()) continue;
                bounds.addToBounds(b);
            }
        }
        return bounds;
    }

    public Bounds getBounds(boolean onModelspace) {
        Bounds bounds = new Bounds();
        Enumeration e = this.entities.elements();
        while (e.hasMoreElements()) {
            ArrayList list = (ArrayList)e.nextElement();
            for (DXFEntity entity : list) {
                if ((!onModelspace || !entity.isModelSpace()) && (onModelspace || entity.isModelSpace())) continue;
                Bounds b = entity.getBounds();
                if (b.getMaximumX() == Double.NaN) {
                    System.out.println("NANA=" + entity);
                }
                if (!b.isValid()) continue;
                bounds.addToBounds(b);
            }
        }
        return bounds;
    }

    public List getDXFEntities(String type) {
        if (this.entities.containsKey(type)) {
            return (ArrayList)this.entities.get(type);
        }
        return null;
    }

    public boolean hasDXFEntities(String type) {
        return this.entities.containsKey(type);
    }

    public Iterator getDXFEntityTypeIterator() {
        return this.entities.keySet().iterator();
    }

    public DXFEntity getDXFEntityByID(String id) {
        DXFEntity entity = null;
        Iterator i = this.entities.values().iterator();
        while (i.hasNext()) {
            for (DXFEntity e : (List)i.next()) {
                if (!e.getID().equals(id)) continue;
                return e;
            }
        }
        return entity;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setLineType(String ltype) {
        this.ltype = ltype;
    }

    public String getLineType() {
        return this.ltype;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public boolean isVisible() {
        return this.color >= 0;
    }

    public boolean isFrozen() {
        return (this.flags & 1) == 1;
    }

    public int getLineWeight() {
        return this.lineWeight;
    }

    public void setLineWeight(int lineWeight) {
        this.lineWeight = lineWeight;
    }

    public String getPlotStyle() {
        return this.plotStyle;
    }

    public void setPlotStyle(String plotStyle) {
        this.plotStyle = plotStyle;
    }
}

